/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.internal.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Stream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Http2GoAwayListener
extends Http2ConnectionAdapter {
    private static final Logger logger = Logger.getLogger(Http2GoAwayListener.class.getName());
    private final Channel ch;
    private boolean goAwaySent;

    public Http2GoAwayListener(Channel ch) {
        this.ch = ch;
    }

    private static String errorStr(long errorCode) {
        Http2Error error = Http2Error.valueOf((long)errorCode);
        return error != null ? error.toString() + '(' + errorCode + ')' : "UNKNOWN(" + errorCode + ')';
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwaySent = true;
        this.onGoAway("Sent", lastStreamId, errorCode, debugData);
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.onGoAway("Received", lastStreamId, errorCode, debugData);
        if (!this.goAwaySent) {
            this.ch.close();
        }
    }

    private void onGoAway(String sentOrReceived, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (errorCode != Http2Error.NO_ERROR.code()) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(MessageFormat.format("{0} {1} a GOAWAY frame: lastStreamId={2}, errorCode={3}, debugData=\"{4}\"", this.ch, sentOrReceived, lastStreamId, Http2GoAwayListener.errorStr(errorCode), debugData.toString(StandardCharsets.UTF_8)));
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("{0} {1} a GOAWAY frame: lastStreamId={2}, errorCode=NO_ERROR", this.ch, sentOrReceived, lastStreamId));
        }
    }

    public void onStreamRemoved(Http2Stream stream) {
        if (stream.id() == 1) {
            logger.fine(MessageFormat.format("{0} HTTP/2 upgrade stream removed: {1}", this.ch, stream.state()));
        }
    }
}

