/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.internal.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import org.xbib.helianthus.common.ClosedSessionException;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;

public abstract class HttpObjectEncoder {
    private volatile boolean closed;

    private static ChannelFuture newFailedFuture(ChannelHandlerContext ctx) {
        return ctx.newFailedFuture((Throwable)ClosedSessionException.get());
    }

    protected static ByteBuf toByteBuf(ChannelHandlerContext ctx, HttpData data) {
        ByteBuf buf = ctx.alloc().directBuffer(data.length(), data.length());
        buf.writeBytes(data.array(), data.offset(), data.length());
        return buf;
    }

    public final ChannelFuture writeHeaders(ChannelHandlerContext ctx, int id, int streamId, HttpHeaders headers, boolean endStream) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (this.closed) {
            return HttpObjectEncoder.newFailedFuture(ctx);
        }
        return this.doWriteHeaders(ctx, id, streamId, headers, endStream);
    }

    protected abstract ChannelFuture doWriteHeaders(ChannelHandlerContext var1, int var2, int var3, HttpHeaders var4, boolean var5);

    public final ChannelFuture writeData(ChannelHandlerContext ctx, int id, int streamId, HttpData data, boolean endStream) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (this.closed) {
            return HttpObjectEncoder.newFailedFuture(ctx);
        }
        return this.doWriteData(ctx, id, streamId, data, endStream);
    }

    protected abstract ChannelFuture doWriteData(ChannelHandlerContext var1, int var2, int var3, HttpData var4, boolean var5);

    public final ChannelFuture writeReset(ChannelHandlerContext ctx, int id, int streamId, Http2Error error) {
        if (this.closed) {
            return HttpObjectEncoder.newFailedFuture(ctx);
        }
        return this.doWriteReset(ctx, id, streamId, error);
    }

    protected abstract ChannelFuture doWriteReset(ChannelHandlerContext var1, int var2, int var3, Http2Error var4);

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.doClose();
    }

    protected abstract void doClose();
}

