package org.xbib.helianthus.common.http;

import java.util.List;

final class DefaultAggregatedHttpMessage implements AggregatedHttpMessage {

    private final List<HttpHeaders> informationals;
    private final HttpHeaders headers;
    private final HttpData content;
    private final HttpHeaders trailingHeaders;
    private final String followUrl;

    DefaultAggregatedHttpMessage(List<HttpHeaders> informationals, HttpHeaders headers,
                                 HttpData content, HttpHeaders trailingHeaders, String followUrl) {
        this.informationals = informationals;
        this.headers = headers;
        this.content = content;
        this.trailingHeaders = trailingHeaders;
        this.followUrl = followUrl;
    }

    @Override
    public List<HttpHeaders> informationals() {
        return informationals;
    }

    @Override
    public HttpHeaders headers() {
        return headers;
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return trailingHeaders;
    }

    @Override
    public HttpData content() {
        return content;
    }

    @Override
    public String followUrl() {
        return followUrl;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultAggregatedHttpMessage:");

        if (!informationals().isEmpty()) {
            sb.append("informationals=").append(informationals());
        }
        sb.append(",headers=").append(headers())
                .append(",content=").append(content());

        if (!trailingHeaders().isEmpty()) {
            sb.append(",trailingheaders=").append(trailingHeaders());
        }

        return sb.toString();
    }
}
