package org.xbib.helianthus.common.http;

import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;

import java.util.Iterator;
import java.util.Map.Entry;

public interface HttpHeaders extends HttpObject, Headers<AsciiString, String, HttpHeaders> {

    HttpHeaders EMPTY_HEADERS = new DefaultHttpHeaders(false, 0).asImmutable();

    static HttpHeaders of(HttpMethod method, String path) {
        return new DefaultHttpHeaders().method(method).path(path);
    }

    static HttpHeaders of(int statusCode) {
        return of(HttpStatus.valueOf(statusCode));
    }

    static HttpHeaders of(HttpStatus status) {
        return new DefaultHttpHeaders().status(status);
    }

    static HttpHeaders of(HttpStatus status, HttpMethod method) {
        return new DefaultHttpHeaders().status(status).method(method);
    }

    static HttpHeaders of(HttpStatus status, HttpMethod method, String path) {
        return new DefaultHttpHeaders().status(status).method(method).path(path);
    }

    static HttpHeaders of(HttpHeaders headers, HttpStatus status, HttpMethod method, String path) {
        return headers.status(status).method(method).path(path);
    }

    static HttpHeaders of(AsciiString name, String value) {
        return new DefaultHttpHeaders().add(name, value);
    }

    static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2) {
        return new DefaultHttpHeaders().add(name1, value1).add(name2, value2);
    }

    static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2,
                          AsciiString name3, String value3) {

        return new DefaultHttpHeaders().add(name1, value1).add(name2, value2)
                .add(name3, value3);
    }

    static HttpHeaders of(AsciiString name1, String value1, AsciiString name2, String value2,
                          AsciiString name3, String value3, AsciiString name4, String value4) {

        return new DefaultHttpHeaders().add(name1, value1).add(name2, value2)
                .add(name3, value3).add(name4, value4);
    }

    /**
     * Returns an iterator over all HTTP/2 headers. The iteration order is as follows:
     * 1. All pseudo headers (order not specified).
     * 2. All non-pseudo headers (in insertion order).
     */
    @Override
    Iterator<Entry<AsciiString, String>> iterator();

    /**
     * Sets the {@link HttpHeaderNames#METHOD} header.
     */
    HttpHeaders method(HttpMethod method);

    /**
     * Sets the {@link HttpHeaderNames#SCHEME} header.
     */
    HttpHeaders scheme(String scheme);

    /**
     * Sets the {@link HttpHeaderNames#AUTHORITY} header.
     */
    HttpHeaders authority(String authority);

    /**
     * Sets the {@link HttpHeaderNames#PATH} header.
     */
    HttpHeaders path(String path);

    /**
     * Sets the {@link HttpHeaderNames#STATUS} header.
     */
    HttpHeaders status(int statusCode);

    /**
     * Sets the {@link HttpHeaderNames#STATUS} header.
     */
    HttpHeaders status(HttpStatus status);

    /**
     * Gets the {@link HttpHeaderNames#METHOD} header or {@code null} if there is no such header.
     */
    HttpMethod method();

    /**
     * Gets the {@link HttpHeaderNames#SCHEME} header or {@code null} if there is no such header.
     */
    String scheme();

    /**
     * Gets the {@link HttpHeaderNames#AUTHORITY} header or {@code null} if there is no such header.
     */
    String authority();

    /**
     * Gets the {@link HttpHeaderNames#PATH} header or {@code null} if there is no such header.
     */
    String path();

    /**
     * Gets the {@link HttpHeaderNames#STATUS} header or {@code null} if there is no such header.
     */
    HttpStatus status();

    default HttpHeaders asImmutable() {
        return new ImmutableHttpHeaders(this);
    }
}
