package org.xbib.helianthus.common.http;

import org.reactivestreams.Publisher;
import org.xbib.helianthus.common.Response;
import org.xbib.helianthus.common.stream.StreamMessage;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface HttpResponse extends Response, StreamMessage<HttpObject> {

    static HttpResponse of(Publisher<? extends HttpObject> publisher) {
        return new PublisherBasedHttpResponse(publisher);
    }

    /**
     * Aggregates the response. The returned {@link CompletableFuture} will be notified when the content and
     * the trailing headers of the response are received fully.
     */
    default CompletableFuture<AggregatedHttpMessage> aggregate() {
        final CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<>();
        subscribe(new HttpResponseAggregator(future));
        return future;
    }

    @Override
    CompletableFuture<Void> closeFuture();

    /**
     * Aggregates the response. The returned {@link CompletableFuture} will be notified when the content and
     * the trailing headers of the response are received fully.
     */
    default CompletableFuture<AggregatedHttpMessage> aggregate(Executor executor) {
        final CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<>();
        subscribe(new HttpResponseAggregator(future), executor);
        return future;
    }
}
