package org.xbib.helianthus.common.http;

import io.netty.handler.codec.ValueConverter;

/**
 * Converts to/from native types, general {@link Object}, and {@link CharSequence}s.
 */
final class StringValueConverter implements ValueConverter<String> {

    static final StringValueConverter INSTANCE = new StringValueConverter();

    private StringValueConverter() {
    }

    @Override
    public String convertObject(Object value) {
        if (value == null) {
            return null;
        }

        return value.toString();
    }

    @Override
    public String convertInt(int value) {
        return String.valueOf(value);
    }

    @Override
    public String convertLong(long value) {
        return String.valueOf(value);
    }

    @Override
    public String convertDouble(double value) {
        return String.valueOf(value);
    }

    @Override
    public String convertChar(char value) {
        return String.valueOf(value);
    }

    @Override
    public String convertBoolean(boolean value) {
        return String.valueOf(value);
    }

    @Override
    public String convertFloat(float value) {
        return String.valueOf(value);
    }

    @Override
    public boolean convertToBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    @Override
    public String convertByte(byte value) {
        return String.valueOf(value & 0xFF);
    }

    @Override
    public byte convertToByte(String value) {
        return (byte) value.charAt(0);
    }

    @Override
    public char convertToChar(String value) {
        return value.charAt(0);
    }

    @Override
    public String convertShort(short value) {
        return String.valueOf(value);
    }

    @Override
    public short convertToShort(String value) {
        return Short.valueOf(value);
    }

    @Override
    public int convertToInt(String value) {
        return Integer.parseInt(value);
    }

    @Override
    public long convertToLong(String value) {
        return Long.parseLong(value);
    }

    @Override
    public String convertTimeMillis(long value) {
        return HeaderDateTimeFormat.format(value);
    }

    @Override
    public long convertToTimeMillis(String value) {
        return HeaderDateTimeFormat.parse(value).toEpochMilli();
    }

    @Override
    public float convertToFloat(String value) {
        return Float.valueOf(value);
    }

    @Override
    public double convertToDouble(String value) {
        return Double.valueOf(value);
    }
}
