package org.xbib.helianthus.common.logging;

public final class DefaultResponseLog
        extends AbstractMessageLog<ResponseLog> implements ResponseLog, ResponseLogBuilder {

    private final RequestLog request;
    private int statusCode;

    public DefaultResponseLog(RequestLog request) {
        this.request = request;
    }

    @Override
    public void start() {
        start0();
    }

    @Override
    public RequestLog request() {
        return request;
    }

    @Override
    public void statusCode(int statusCode) {
        if (isDone()) {
            return;
        }

        this.statusCode = statusCode;
    }

    @Override
    public int statusCode() {
        return statusCode;
    }

    @Override
    protected void append(StringBuilder sb) {
        sb.append(",statusCode=").append(statusCode);
    }

}
