package org.xbib.helianthus.common.logging;

import org.xbib.helianthus.common.RequestContext;

import java.util.Objects;

public interface MessageLogConsumer {

    /**
     * Invoked when a request has been streamed.
     */
    void onRequest(RequestContext ctx, RequestLog req) throws Exception;

    /**
     * Invoked when a response has been streamed.
     */
    void onResponse(RequestContext ctx, ResponseLog res) throws Exception;

    default MessageLogConsumer andThen(MessageLogConsumer other) {
        Objects.requireNonNull(other, "other");

        final MessageLogConsumer first = this;
        final MessageLogConsumer second = other;

        return new MessageLogConsumer() {
            @Override
            public void onRequest(RequestContext ctx, RequestLog req) throws Exception {
                MessageLogConsumerInvoker.invokeOnRequest(first, ctx, req);
                second.onRequest(ctx, req);
            }

            @Override
            public void onResponse(RequestContext ctx, ResponseLog res) throws Exception {
                MessageLogConsumerInvoker.invokeOnResponse(first, ctx, res);
                second.onResponse(ctx, res);
            }
        };
    }
}

