package org.xbib.helianthus.common.stream;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface StreamMessage<T> extends Publisher<T> {
    boolean isOpen();

    boolean isEmpty();

    CompletableFuture<Void> closeFuture();

    @Override
    void subscribe(Subscriber<? super T> s);

    void subscribe(Subscriber<? super T> s, Executor executor);

    void abort();
}
