package org.xbib.helianthus.internal;

import static java.util.Objects.requireNonNull;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;

public final class NoopAttribute<T> implements Attribute<T> {

    private final AttributeKey<T> key;

    public NoopAttribute(AttributeKey<T> key) {
        this.key = requireNonNull(key, "key");
    }

    @Override
    public AttributeKey<T> key() {
        return key;
    }

    @Override
    public T get() {
        return null;
    }

    @Override
    public void set(T value) {
    }

    @Override
    public T getAndSet(T value) {
        return null;
    }

    @Override
    public T setIfAbsent(T value) {
        return null;
    }

    @Override
    public T getAndRemove() {
        return null;
    }

    @Override
    public boolean compareAndSet(T oldValue, T newValue) {
        return true;
    }

    @Override
    public void remove() {
    }

    @Override
    public String toString() {
        return "NoopAttribute(" + key + ')';
    }
}
