/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MimeTypeParams {
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\s*;\\s*([^=\\s]+)\\s*=\\s*(?:([^\"][^;]*)|\"((?:[^\\\\\"]|\\\\.)*)\")");

    private MimeTypeParams() {
    }

    static String find(String params, String name) {
        assert (name != null);
        if (params == null) {
            return null;
        }
        Matcher m = PARAM_PATTERN.matcher(params);
        while (m.find()) {
            String matchedName = m.group(1);
            String unquotedValue = m.group(2);
            String quotedValue = m.group(3);
            if (!name.equals(matchedName)) continue;
            return unquotedValue != null ? unquotedValue : MimeTypeParams.unquote(quotedValue);
        }
        return null;
    }

    private static String unquote(String value) {
        int length = value.length();
        StringBuilder buf = new StringBuilder(length);
        boolean escaped = false;
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (escaped) {
                buf.append(c);
                escaped = false;
                continue;
            }
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            escaped = true;
        }
        return buf.toString();
    }
}

