/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeMap;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.xbib.helianthus.common.RequestContextAwareEventLoop;
import org.xbib.helianthus.common.RequestContextThreadLocal;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.TimeoutException;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.RequestLogBuilder;
import org.xbib.helianthus.common.logging.ResponseLog;
import org.xbib.helianthus.common.logging.ResponseLogBuilder;
import org.xbib.helianthus.common.util.Exceptions;

public interface RequestContext
extends AttributeMap {
    public static <T extends RequestContext> T current() {
        Object ctx = RequestContextThreadLocal.get();
        if (ctx == null) {
            throw new IllegalStateException(RequestContext.class.getSimpleName() + " unavailable");
        }
        return ctx;
    }

    public static <T> T mapCurrent(Function<? super RequestContext, T> mapper, Supplier<T> defaultValueSupplier) {
        Object ctx = RequestContextThreadLocal.get();
        if (ctx != null) {
            return mapper.apply((RequestContext)ctx);
        }
        if (defaultValueSupplier != null) {
            return defaultValueSupplier.get();
        }
        return null;
    }

    public static PushHandle push(RequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        Object oldCtx = RequestContextThreadLocal.getAndSet(ctx);
        return oldCtx != null ? () -> RequestContextThreadLocal.set(oldCtx) : RequestContextThreadLocal::remove;
    }

    public SessionProtocol sessionProtocol();

    public String method();

    public String path();

    public <T> T request();

    public RequestLogBuilder requestLogBuilder();

    public ResponseLogBuilder responseLogBuilder();

    public CompletableFuture<RequestLog> requestLogFuture();

    public CompletableFuture<ResponseLog> responseLogFuture();

    public Iterator<Attribute<?>> attrs();

    public EventLoop eventLoop();

    default public EventLoop contextAwareEventLoop() {
        return new RequestContextAwareEventLoop(this, this.eventLoop());
    }

    default public Executor makeContextAware(Executor executor) {
        return runnable -> executor.execute(this.makeContextAware(runnable));
    }

    public <T> Callable<T> makeContextAware(Callable<T> var1);

    public Runnable makeContextAware(Runnable var1);

    @Deprecated
    public <T> FutureListener<T> makeContextAware(FutureListener<T> var1);

    @Deprecated
    public ChannelFutureListener makeContextAware(ChannelFutureListener var1);

    @Deprecated
    public <T extends Future<?>> GenericFutureListener<T> makeContextAware(GenericFutureListener<T> var1);

    public void onEnter(Runnable var1);

    public void onExit(Runnable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    default public void resolvePromise(Promise<?> promise, Object result) {
        Promise<?> castPromise = promise;
        if (castPromise.trySuccess(result)) {
            return;
        }
        try {
            if (!(promise.cause() instanceof TimeoutException)) {
                Logger.getLogger(RequestContext.class.getName()).warning(MessageFormat.format("Failed to resolve a completed promise ({0}) with {1}", promise, result));
            }
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)result);
        }
    }

    @Deprecated
    default public void rejectPromise(Promise<?> promise, Throwable cause) {
        if (promise.tryFailure(cause)) {
            return;
        }
        Throwable firstCause = promise.cause();
        if (firstCause instanceof TimeoutException) {
            return;
        }
        if (Exceptions.isExpected(cause)) {
            return;
        }
        Logger.getLogger(RequestContext.class.getName()).warning(MessageFormat.format("Failed to reject a completed promise ({0}) with {1}", promise, cause, cause));
    }

    @FunctionalInterface
    public static interface PushHandle
    extends AutoCloseable {
        @Override
        public void close();
    }
}

