/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.xbib.helianthus.common.SerializationFormat;
import org.xbib.helianthus.common.SessionProtocol;

public final class Scheme
implements Comparable<Scheme> {
    private static final Map<String, Scheme> SCHEMES;
    private final SerializationFormat serializationFormat;
    private final SessionProtocol sessionProtocol;
    private final String uriText;

    private Scheme(SerializationFormat serializationFormat, SessionProtocol sessionProtocol) {
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.uriText = this.serializationFormat().uriText() + '+' + this.sessionProtocol().uriText();
    }

    public static Optional<Scheme> tryParse(String scheme) {
        if (scheme == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(SCHEMES.get(scheme.toLowerCase(Locale.US)));
    }

    public static Scheme parse(String scheme) {
        Scheme res = SCHEMES.get(Objects.requireNonNull(scheme, "scheme").toLowerCase(Locale.US));
        if (res == null) {
            throw new IllegalArgumentException("scheme: " + scheme);
        }
        return res;
    }

    public static Scheme of(SerializationFormat serializationFormat, SessionProtocol sessionProtocol) {
        return SCHEMES.get(Objects.requireNonNull(serializationFormat, "serializationFormat").uriText() + '+' + Objects.requireNonNull(sessionProtocol, "sessionProtocol").uriText());
    }

    public SerializationFormat serializationFormat() {
        return this.serializationFormat;
    }

    public SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    public String uriText() {
        return this.uriText;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(Scheme o) {
        return this.uriText().compareTo(o.uriText());
    }

    public String toString() {
        return this.uriText();
    }

    static {
        HashMap<String, Scheme> schemes = new HashMap<String, Scheme>();
        for (SerializationFormat f : SerializationFormat.values()) {
            for (SessionProtocol p : SessionProtocol.values()) {
                String ftxt = f.uriText();
                String ptxt = p.uriText();
                assert (ftxt.equals(ftxt.toLowerCase(Locale.US)));
                assert (ptxt.equals(ptxt.toLowerCase(Locale.US)));
                Scheme scheme = new Scheme(f, p);
                schemes.put(ftxt + '+' + ptxt, scheme);
                schemes.put(ptxt + '+' + ftxt, scheme);
            }
        }
        SCHEMES = Collections.unmodifiableMap(schemes);
    }
}

