/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.AsciiString;
import java.util.List;
import java.util.Objects;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.http.StringValueConverter;
import org.xbib.helianthus.internal.http.HelianthusHttpUtil;

public final class DefaultHttpHeaders
extends DefaultHeaders<AsciiString, String, HttpHeaders>
implements HttpHeaders {
    private static final DefaultHeaders.NameValidator<AsciiString> HTTP2_NAME_VALIDATOR = name -> {
        int index;
        if (name == null) {
            throw new NullPointerException("header name");
        }
        try {
            index = name.forEachByte(value -> !AsciiString.isUpperCase((byte)value));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid header name: " + name, e);
        }
        if (index != -1) {
            throw new IllegalArgumentException("invalid header name: " + name);
        }
    };
    private HttpMethod method;
    private HttpStatus status;

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean validate) {
        this(validate, 16);
    }

    public DefaultHttpHeaders(boolean validate, int initialCapacity) {
        super(HelianthusHttpUtil.HTTP2_HEADER_NAME_HASHER, (ValueConverter)StringValueConverter.INSTANCE, validate ? HTTP2_NAME_VALIDATOR : DefaultHeaders.NameValidator.NOT_NULL, initialCapacity);
    }

    @Override
    public HttpHeaders method(HttpMethod method) {
        Objects.requireNonNull(method, "method");
        this.method = method;
        this.set(HttpHeaderNames.METHOD, method.name());
        return this;
    }

    @Override
    public HttpHeaders scheme(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        this.set(HttpHeaderNames.SCHEME, scheme);
        return this;
    }

    @Override
    public HttpHeaders authority(String authority) {
        Objects.requireNonNull(authority, "authority");
        this.set(HttpHeaderNames.AUTHORITY, authority);
        return this;
    }

    @Override
    public HttpHeaders path(String path) {
        Objects.requireNonNull(path, "path");
        this.set(HttpHeaderNames.PATH, path);
        return this;
    }

    @Override
    public HttpHeaders status(int statusCode) {
        HttpStatus status = this.status = HttpStatus.valueOf(statusCode);
        this.set(HttpHeaderNames.STATUS, status.codeAsText());
        return this;
    }

    @Override
    public HttpHeaders status(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        return this.status(status.code());
    }

    @Override
    public HttpMethod method() {
        HttpMethod method = this.method;
        if (method != null) {
            return method;
        }
        String methodStr = (String)this.get(HttpHeaderNames.METHOD);
        if (methodStr == null) {
            return null;
        }
        try {
            this.method = HttpMethod.valueOf(methodStr);
            return this.method;
        }
        catch (IllegalArgumentException ignored) {
            throw new IllegalStateException("unknown method: " + methodStr);
        }
    }

    @Override
    public String scheme() {
        return (String)this.get(HttpHeaderNames.SCHEME);
    }

    @Override
    public String authority() {
        return (String)this.get(HttpHeaderNames.AUTHORITY);
    }

    @Override
    public String path() {
        return (String)this.get(HttpHeaderNames.PATH);
    }

    @Override
    public HttpStatus status() {
        HttpStatus status = this.status;
        if (status != null) {
            return status;
        }
        String statusStr = (String)this.get(HttpHeaderNames.STATUS);
        if (statusStr == null) {
            return null;
        }
        try {
            this.status = HttpStatus.valueOf(Integer.parseInt(statusStr));
            return this.status;
        }
        catch (NumberFormatException ignored) {
            throw new IllegalStateException("invalid status: " + statusStr);
        }
    }

    public String toString() {
        int size = this.size();
        if (size == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder(this.size() * 16).append('[');
        String separator = "";
        for (AsciiString name : this.names()) {
            List values = this.getAll(name);
            for (int i = 0; i < values.size(); ++i) {
                buf.append(separator);
                buf.append((CharSequence)name).append('=').append((String)values.get(i));
            }
            separator = ", ";
        }
        return buf.append(']').toString();
    }
}

