/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.concurrent.CompletableFuture;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpMessageAggregator;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpRequest;

final class HttpRequestAggregator
extends HttpMessageAggregator {
    private final HttpRequest request;
    private HttpHeaders trailingHeaders;

    HttpRequestAggregator(HttpRequest request, CompletableFuture<AggregatedHttpMessage> future) {
        super(future);
        this.request = request;
        this.trailingHeaders = HttpHeaders.EMPTY_HEADERS;
    }

    public void onNext(HttpObject o) {
        if (o instanceof HttpHeaders) {
            this.trailingHeaders = (HttpHeaders)o;
        } else {
            this.add((HttpData)o);
        }
    }

    public void onError(Throwable t) {
        this.clear();
        this.future().completeExceptionally(t);
    }

    @Override
    protected void doClear() {
        this.trailingHeaders.clear();
        this.contentList.clear();
    }

    public void onComplete() {
        HttpData content = this.finish();
        this.future().complete(AggregatedHttpMessage.of(this.request.headers(), content, this.trailingHeaders, null));
    }
}

