/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import java.text.MessageFormat;
import java.util.logging.Logger;
import org.xbib.helianthus.common.logging.RequestContextAwareLogger;

public enum LogLevel {
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR;


    public void log(RequestContextAwareLogger logger, String format, Object arg1) {
        switch (this) {
            case TRACE: {
                logger.trace(MessageFormat.format(format, arg1));
                break;
            }
            case DEBUG: {
                logger.debug(MessageFormat.format(format, arg1));
                break;
            }
            case INFO: {
                logger.info(MessageFormat.format(format, arg1));
                break;
            }
            case WARN: {
                logger.warn(MessageFormat.format(format, arg1));
                break;
            }
            case ERROR: {
                logger.error(MessageFormat.format(format, arg1));
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, Object arg1, Object arg2) {
        switch (this) {
            case TRACE: {
                logger.finer(MessageFormat.format(format, arg1, arg2));
                break;
            }
            case DEBUG: {
                logger.fine(MessageFormat.format(format, arg1, arg2));
                break;
            }
            case INFO: {
                logger.info(MessageFormat.format(format, arg1, arg2));
                break;
            }
            case WARN: {
                logger.warning(MessageFormat.format(format, arg1, arg2));
                break;
            }
            case ERROR: {
                logger.severe(MessageFormat.format(format, arg1, arg2));
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

