/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.helianthus.common.RequestContext;

public final class RequestContextAwareLogger {
    private final RequestContext ctx;
    private final Logger l;

    public RequestContextAwareLogger(RequestContext ctx, Logger l) {
        this.ctx = ctx;
        this.l = l;
    }

    private String decorate(String msg) {
        String prefix = this.ctx.toString();
        return new StringBuilder(prefix.length() + 1 + msg.length()).append(prefix).append(' ').append(msg).toString();
    }

    public String getName() {
        return this.l.getName();
    }

    public boolean isTraceEnabled() {
        return this.l.isLoggable(Level.FINER);
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.l.finer(this.decorate(msg));
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.l.finer(MessageFormat.format(this.decorate(format), arg));
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.l.finer(MessageFormat.format(this.decorate(format), arg1, arg2));
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.l.finer(MessageFormat.format(this.decorate(format), arguments));
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.l.finer(MessageFormat.format(this.decorate(msg), t));
        }
    }

    public boolean isDebugEnabled() {
        return this.l.isLoggable(Level.FINE);
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.l.fine(this.decorate(msg));
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.l.fine(MessageFormat.format(this.decorate(format), arg));
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.l.fine(MessageFormat.format(this.decorate(format), arg1, arg2));
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.l.fine(MessageFormat.format(this.decorate(format), arguments));
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.l.fine(MessageFormat.format(this.decorate(msg), t));
        }
    }

    public boolean isInfoEnabled() {
        return this.l.isLoggable(Level.INFO);
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.l.info(this.decorate(msg));
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.l.info(MessageFormat.format(this.decorate(format), arg));
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.l.info(MessageFormat.format(this.decorate(format), arg1, arg2));
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.l.info(MessageFormat.format(this.decorate(format), arguments));
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.l.info(MessageFormat.format(this.decorate(msg), t));
        }
    }

    public boolean isWarnEnabled() {
        return this.l.isLoggable(Level.WARNING);
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.l.warning(this.decorate(msg));
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.l.warning(MessageFormat.format(this.decorate(format), arg));
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.l.warning(MessageFormat.format(this.decorate(format), arg1, arg2));
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.l.warning(MessageFormat.format(this.decorate(format), arguments));
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.l.warning(MessageFormat.format(this.decorate(msg), t));
        }
    }

    public boolean isErrorEnabled() {
        return this.l.isLoggable(Level.SEVERE);
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.l.severe(this.decorate(msg));
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.l.severe(MessageFormat.format(this.decorate(format), arg));
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.l.severe(MessageFormat.format(this.decorate(format), arg1, arg2));
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.l.severe(MessageFormat.format(this.decorate(format), arguments));
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.l.severe(MessageFormat.format(this.decorate(msg), t));
        }
    }

    public String toString() {
        return "ServiceAwareLogger(" + this.l + ')';
    }
}

