package org.xbib.helianthus.common.http;

import java.util.concurrent.CompletableFuture;

final class HttpRequestAggregator extends HttpMessageAggregator {

    private final HttpRequest request;
    private HttpHeaders trailingHeaders;

    HttpRequestAggregator(HttpRequest request, CompletableFuture<AggregatedHttpMessage> future) {
        super(future);
        this.request = request;
        trailingHeaders = HttpHeaders.EMPTY_HEADERS;
    }

    @Override
    public void onNext(HttpObject o) {
        if (o instanceof HttpHeaders) {
            trailingHeaders = (HttpHeaders) o;
        } else {
            add((HttpData) o);
        }
    }

    @Override
    public void onError(Throwable t) {
        clear();
        future().completeExceptionally(t);
    }

    @Override
    protected void doClear() {
        trailingHeaders.clear();
    }

    @Override
    public void onComplete() {
        final HttpData content = finish();
        future().complete(AggregatedHttpMessage.of(request.headers(), content, trailingHeaders, null));
    }
}
