package org.xbib.helianthus.common.logging;

import io.netty.channel.Channel;
import org.xbib.helianthus.common.SerializationFormat;
import org.xbib.helianthus.common.SessionProtocol;

final class NoopRequestLogBuilder implements RequestLogBuilder {

    @Override
    public void startRequest(
            Channel ch, SessionProtocol sessionProtocol, String host, String method, String path) {}

    @Override
    public void serializationFormat(SerializationFormat serializationFormat) {}

    @Override
    public void increaseRequestLength(long deltaBytes) {}

    @Override
    public void requestLength(long requestLength) {}

    @Override
    public void requestEnvelope(Object requestEnvelope) {}

    @Override
    public void requestContent(Object requestContent, Object rawRequestContent) {}

    @Override
    public void deferRequestContent() {}

    @Override
    public boolean isRequestContentDeferred() {
        return false;
    }

    @Override
    public void endRequest() {}

    @Override
    public void endRequest(Throwable requestCause) {}

    @Override
    public void startResponse() {}

    @Override
    public void statusCode(int statusCode) {}

    @Override
    public void increaseResponseLength(long deltaBytes) {}

    @Override
    public void responseLength(long responseLength) {}

    @Override
    public void responseEnvelope(Object responseEnvelope) {}

    @Override
    public void responseContent(Object responseContent, Object rawResponseContent) {}

    @Override
    public void deferResponseContent() {}

    @Override
    public boolean isResponseContentDeferred() {
        return false;
    }

    @Override
    public void endResponse() {}

    @Override
    public void endResponse(Throwable responseCause) {}
}
