/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xbib.helianthus.common.RpcResponse;
import org.xbib.helianthus.common.util.Exceptions;

public class AbstractRpcResponse
extends CompletableFuture<Object>
implements RpcResponse {
    private static final CancellationException CANCELLED = Exceptions.clearTrace(new CancellationException());
    private static final AtomicReferenceFieldUpdater<AbstractRpcResponse, Throwable> causeUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractRpcResponse.class, Throwable.class, "cause");
    private volatile Throwable cause;

    protected AbstractRpcResponse() {
    }

    protected AbstractRpcResponse(Object result) {
        this.complete(result);
    }

    protected AbstractRpcResponse(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.completeExceptionally(cause);
    }

    @Override
    public final Throwable getCause() {
        return this.cause;
    }

    @Override
    public boolean completeExceptionally(Throwable cause) {
        causeUpdater.compareAndSet(this, null, Objects.requireNonNull(cause));
        return super.completeExceptionally(cause);
    }

    @Override
    public void obtrudeException(Throwable cause) {
        this.cause = Objects.requireNonNull(cause);
        super.obtrudeException(cause);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completeExceptionally(CANCELLED) || this.isCancelled();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isDone()) {
            if (this.isCompletedExceptionally()) {
                sb.append("AbstractRpcResponse:").append("cause=").append(this.cause);
                return sb.toString();
            }
            sb.append("AbstractRpcResponse:").append("value=").append((Object)this.getNow(null));
            return sb.toString();
        }
        int count = this.getNumberOfDependents();
        if (count == 0) {
            sb.append("not completed");
            return sb.toString();
        }
        sb.append("not completed, dependents=").append(count);
        return sb.toString();
    }
}

