/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.RequestContextAwareFuture;
import org.xbib.helianthus.common.RequestContextAwareProgressivePromise;
import org.xbib.helianthus.common.RequestContextAwarePromise;

final class RequestContextAwareEventLoop
implements EventLoop {
    private final RequestContext context;
    private final EventLoop delegate;

    RequestContextAwareEventLoop(RequestContext context, EventLoop delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    public EventLoop next() {
        return this.delegate.next();
    }

    public EventLoopGroup parent() {
        return this.delegate.parent();
    }

    public boolean inEventLoop() {
        return this.delegate.inEventLoop();
    }

    public boolean inEventLoop(Thread thread) {
        return this.delegate.inEventLoop(thread);
    }

    public <V> Promise<V> newPromise() {
        return new RequestContextAwarePromise(this.context, this.delegate.newPromise());
    }

    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new RequestContextAwareProgressivePromise(this.context, this.delegate.newProgressivePromise());
    }

    public <V> Future<V> newSucceededFuture(V result) {
        return new RequestContextAwareFuture(this.context, this.delegate.newSucceededFuture(result));
    }

    public <V> Future<V> newFailedFuture(Throwable cause) {
        return new RequestContextAwareFuture(this.context, this.delegate.newFailedFuture(cause));
    }

    public boolean isShuttingDown() {
        return this.delegate.isShuttingDown();
    }

    public Future<?> shutdownGracefully() {
        return this.delegate.shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.delegate.shutdownGracefully(quietPeriod, timeout, unit);
    }

    public Future<?> terminationFuture() {
        return this.delegate.terminationFuture();
    }

    @Deprecated
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Deprecated
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Deprecated
    public Iterator<EventExecutor> iterator() {
        return this.delegate.iterator();
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.context.makeContextAware(task));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.context.makeContextAware(task), result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.context.makeContextAware(task));
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.context.makeContextAware(command), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.context.makeContextAware(callable), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(this.context.makeContextAware(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(this.context.makeContextAware(command), initialDelay, delay, unit);
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.makeContextAware(tasks));
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.makeContextAware(tasks), timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny(this.makeContextAware(tasks));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny(this.makeContextAware(tasks), timeout, unit);
    }

    public void execute(Runnable command) {
        this.delegate.execute(this.context.makeContextAware(command));
    }

    private <T> Collection<? extends Callable<T>> makeContextAware(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this.context::makeContextAware).collect(Collectors.toList());
    }

    public ChannelFuture register(Channel channel) {
        return this.delegate.register(channel);
    }

    public ChannelFuture register(ChannelPromise channelPromise) {
        return this.delegate.register(channelPromise);
    }

    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        return this.delegate.register(channel, channelPromise);
    }
}

