/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import java.util.Locale;
import java.util.Optional;

public enum SerializationFormat {
    NONE("none", "application", "x-none"),
    UNKNOWN("unknown", "application", "x-unknown");

    private final String uriText;
    private final String mediaType;

    private SerializationFormat(String uriText, String mediaType, String subType) {
        this.uriText = uriText;
        this.mediaType = mediaType + "/" + subType;
    }

    public static Optional<SerializationFormat> fromMediaType(String mediaType) {
        if (mediaType == null || mediaType.isEmpty()) {
            return Optional.empty();
        }
        int semicolonIdx = mediaType.indexOf(59);
        if (semicolonIdx >= 0) {
            String paramPart = mediaType.substring(semicolonIdx).toLowerCase(Locale.US);
            mediaType = mediaType.substring(0, semicolonIdx).toLowerCase(Locale.US).trim();
        } else {
            Object paramPart = null;
            mediaType = mediaType.toLowerCase(Locale.US).trim();
        }
        if (NONE.mediaType().equals(mediaType)) {
            return Optional.of(NONE);
        }
        return Optional.empty();
    }

    public String uriText() {
        return this.uriText;
    }

    public String mediaType() {
        return this.mediaType;
    }
}

