/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.Objects;
import org.xbib.helianthus.common.http.DefaultHttpHeaders;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpRequest;
import org.xbib.helianthus.common.http.HttpRequestWriter;
import org.xbib.helianthus.common.stream.DefaultStreamMessage;

public class DefaultHttpRequest
extends DefaultStreamMessage<HttpObject>
implements HttpRequest,
HttpRequestWriter {
    private final HttpHeaders headers;
    private final boolean keepAlive;

    public DefaultHttpRequest() {
        this(new DefaultHttpHeaders());
    }

    public DefaultHttpRequest(HttpHeaders headers) {
        this(headers, true);
    }

    public DefaultHttpRequest(HttpMethod method, String path) {
        this(HttpHeaders.of(method, path));
    }

    public DefaultHttpRequest(HttpHeaders headers, boolean keepAlive) {
        this.headers = Objects.requireNonNull(headers, "headers");
        this.keepAlive = keepAlive;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultHttpRequest:keepAlive=").append(this.isKeepAlive()).append(",headers=").append(this.headers());
        return sb.toString();
    }
}

