/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.security;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class SelfSignedCertificate {
    private static final Logger logger = Logger.getLogger(SelfSignedCertificate.class.getName());
    private static final Date DEFAULT_NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date DEFAULT_NOT_AFTER = new Date(253402300799000L);
    private String certText;
    private String keyText;
    private X509Certificate cert;
    private PrivateKey key;

    public SelfSignedCertificate() throws CertificateException, NoSuchAlgorithmException, IOException, SignatureException, NoSuchProviderException, InvalidKeyException {
        this("example.com");
    }

    public SelfSignedCertificate(String fqdn) throws CertificateException, NoSuchAlgorithmException, IOException, SignatureException, NoSuchProviderException, InvalidKeyException {
        this(fqdn, new SecureRandom(), 2048);
    }

    public SelfSignedCertificate(String fqdn, SecureRandom random, int bits) throws NoSuchAlgorithmException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException, IOException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(bits, random);
        KeyPair keypair = keyGen.generateKeyPair();
        this.generate(fqdn, keypair, random);
    }

    public InputStream certificate() {
        return new ByteArrayInputStream(this.certText.getBytes(CharsetUtil.US_ASCII));
    }

    public InputStream privateKey() {
        return new ByteArrayInputStream(this.keyText.getBytes(CharsetUtil.US_ASCII));
    }

    public X509Certificate cert() {
        return this.cert;
    }

    public PrivateKey key() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(String fqdn, KeyPair keypair, SecureRandom random) throws IOException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        ByteBuf encodedBuf;
        PrivateKey key = keypair.getPrivate();
        X509CertInfo info = new X509CertInfo();
        X500Name owner = new X500Name("CN=" + fqdn);
        info.set("version", new CertificateVersion(2));
        info.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, random)));
        try {
            info.set("subject", new CertificateSubjectName(owner));
        }
        catch (CertificateException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            info.set("subject", owner);
        }
        try {
            info.set("issuer", new CertificateIssuerName(owner));
        }
        catch (CertificateException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            info.set("issuer", owner);
        }
        info.set("validity", new CertificateValidity(DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER));
        info.set("key", new CertificateX509Key(keypair.getPublic()));
        info.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid)));
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(key, "SHA1withRSA");
        info.set("algorithmID.algorithm", cert.get("x509.algorithm"));
        cert = new X509CertImpl(info);
        cert.sign(key, "SHA1withRSA");
        cert.verify(keypair.getPublic());
        ByteBuf wrappedBuf = Unpooled.wrappedBuffer((byte[])key.getEncoded());
        try {
            encodedBuf = Base64.encode((ByteBuf)wrappedBuf, (boolean)true);
            try {
                this.keyText = "-----BEGIN PRIVATE KEY-----\n" + encodedBuf.toString(CharsetUtil.US_ASCII) + "\n-----END PRIVATE KEY-----\n";
            }
            finally {
                encodedBuf.release();
            }
        }
        finally {
            wrappedBuf.release();
        }
        wrappedBuf = Unpooled.wrappedBuffer((byte[])cert.getEncoded());
        try {
            encodedBuf = Base64.encode((ByteBuf)wrappedBuf, (boolean)true);
            try {
                this.certText = "-----BEGIN CERTIFICATE-----\n" + encodedBuf.toString(CharsetUtil.US_ASCII) + "\n-----END CERTIFICATE-----\n";
            }
            finally {
                encodedBuf.release();
            }
        }
        finally {
            wrappedBuf.release();
        }
        ByteArrayInputStream certStream = new ByteArrayInputStream(this.certText.getBytes(CharsetUtil.US_ASCII));
        this.key = keypair.getPrivate();
        this.cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(certStream);
    }
}

