/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;

public final class TextFormatter {
    private static final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX").toFormatter(Locale.ENGLISH).withZone(ZoneId.of("GMT"));

    private TextFormatter() {
    }

    public static void appendSize(StringBuilder buf, long size) {
        if (size >= 0x6400000L) {
            buf.append(size / 0x100000L).append("MiB(").append(size).append("B)");
        } else if (size >= 102400L) {
            buf.append(size / 1024L).append("KiB(").append(size).append("B)");
        } else {
            buf.append(size).append('B');
        }
    }

    public static void appendElapsed(StringBuilder buf, long elapsedNanos) {
        if (elapsedNanos >= 100000000000L) {
            buf.append(elapsedNanos / 1000000000L).append("s(").append(elapsedNanos).append("ns)");
        } else if (elapsedNanos >= 100000000L) {
            buf.append(elapsedNanos / 1000000L).append("ms(").append(elapsedNanos).append("ns)");
        } else if (elapsedNanos >= 100000L) {
            buf.append(elapsedNanos / 1000L).append("\u00b5s(").append(elapsedNanos).append("ns)");
        } else {
            buf.append(elapsedNanos).append("ns");
        }
    }

    public static void appendElapsed(StringBuilder buf, long startTimeNanos, long endTimeNanos) {
        TextFormatter.appendElapsed(buf, endTimeNanos - startTimeNanos);
    }

    public static void appendElapsedAndSize(StringBuilder buf, long startTimeNanos, long endTimeNanos, long size) {
        TextFormatter.appendElapsed(buf, startTimeNanos, endTimeNanos);
        buf.append(", ");
        TextFormatter.appendSize(buf, size);
    }

    public static StringBuilder elapsed(long elapsedNanos) {
        StringBuilder buf = new StringBuilder(16);
        TextFormatter.appendElapsed(buf, elapsedNanos);
        return buf;
    }

    public static StringBuilder elapsed(long startTimeNanos, long endTimeNanos) {
        return TextFormatter.elapsed(endTimeNanos - startTimeNanos);
    }

    public static StringBuilder size(long size) {
        StringBuilder buf = new StringBuilder(16);
        TextFormatter.appendSize(buf, size);
        return buf;
    }

    public static StringBuilder elapsedAndSize(long startTimeNanos, long endTimeNanos, long size) {
        StringBuilder buf = new StringBuilder(16);
        TextFormatter.appendElapsedAndSize(buf, startTimeNanos, endTimeNanos, size);
        return buf;
    }

    public static void appendEpoch(StringBuilder buf, long timeMillis) {
        buf.append(dateTimeFormatter.format(Instant.ofEpochMilli(timeMillis))).append('(').append(timeMillis).append(')');
    }

    public static StringBuilder epoch(long timeMillis) {
        StringBuilder buf = new StringBuilder(46);
        TextFormatter.appendEpoch(buf, timeMillis);
        return buf;
    }
}

