/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpObject;

abstract class HttpMessageAggregator
implements Subscriber<HttpObject> {
    private final List<HttpData> contentList = new ArrayList<HttpData>();
    private final CompletableFuture<AggregatedHttpMessage> future;
    private int contentLength;
    private Subscription subscription;

    protected HttpMessageAggregator(CompletableFuture<AggregatedHttpMessage> future) {
        this.future = future;
    }

    protected final CompletableFuture<AggregatedHttpMessage> future() {
        return this.future;
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        s.request(Long.MAX_VALUE);
    }

    protected final void add(HttpData data) {
        int dataLength = data.length();
        if (dataLength > 0) {
            if (this.contentLength > Integer.MAX_VALUE - dataLength) {
                this.clear();
                this.subscription.cancel();
                throw new IllegalStateException("content length greater than Integer.MAX_VALUE");
            }
            this.contentList.add(data);
            this.contentLength += dataLength;
        }
    }

    protected final void clear() {
        this.doClear();
        this.contentList.clear();
    }

    protected void doClear() {
    }

    protected final HttpData finish() {
        HttpData content;
        if (this.contentLength == 0) {
            content = HttpData.EMPTY_DATA;
        } else {
            byte[] merged = new byte[this.contentLength];
            int offset = 0;
            for (int i = 0; i < this.contentList.size(); ++i) {
                HttpData data = this.contentList.set(i, null);
                int dataLength = data.length();
                System.arraycopy(data.array(), data.offset(), merged, offset, dataLength);
                offset += dataLength;
            }
            content = HttpData.of(merged);
        }
        return content;
    }
}

