/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.HttpData;
import org.xbib.helianthus.common.http.HttpHeaderNames;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpMessageAggregator;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpStatus;
import org.xbib.helianthus.common.http.HttpStatusClass;

final class HttpResponseAggregator
extends HttpMessageAggregator {
    private List<HttpHeaders> informationals;
    private HttpHeaders headers;
    private HttpHeaders trailingHeaders = HttpHeaders.EMPTY_HEADERS;

    HttpResponseAggregator(CompletableFuture<AggregatedHttpMessage> future) {
        super(future);
    }

    public void onNext(HttpObject o) {
        if (o instanceof HttpHeaders) {
            HttpHeaders headers = (HttpHeaders)o;
            if (headers.status().codeClass() == HttpStatusClass.INFORMATIONAL) {
                if (this.informationals == null) {
                    this.informationals = new ArrayList<HttpHeaders>(2);
                }
                this.informationals.add(headers);
            } else if (this.headers == null) {
                this.headers = headers;
            } else {
                this.trailingHeaders = headers;
            }
        } else {
            this.add((HttpData)o);
        }
    }

    public void onError(Throwable t) {
        this.clear();
        this.future().completeExceptionally(t);
    }

    @Override
    protected void doClear() {
        this.headers = null;
        this.trailingHeaders = null;
    }

    public void onComplete() {
        HttpData content = this.finish();
        String followUrl = null;
        if ((this.headers.status().equals(HttpStatus.MOVED_PERMANENTLY) || this.headers.status().equals(HttpStatus.TEMPORARY_REDIRECT) || this.headers.status().equals(HttpStatus.FOUND) || this.headers.status().equals(HttpStatus.SEE_OTHER)) && this.headers.contains(HttpHeaderNames.LOCATION)) {
            followUrl = (String)this.headers.get(HttpHeaderNames.LOCATION);
        }
        this.future().complete(AggregatedHttpMessage.of(this.informationals != null ? this.informationals : Collections.emptyList(), this.headers, content, this.trailingHeaders, followUrl));
    }
}

