/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.Scheme;
import org.xbib.helianthus.common.SerializationFormat;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.logging.RequestLogAvailability;
import org.xbib.helianthus.common.logging.RequestLogAvailabilityException;
import org.xbib.helianthus.common.logging.RequestLogListener;

public interface RequestLog {
    public Set<RequestLogAvailability> availabilities();

    public boolean isAvailable(RequestLogAvailability var1);

    default public boolean isAvailable(RequestLogAvailability ... availabilities) {
        for (RequestLogAvailability k : Objects.requireNonNull(availabilities, "availabilities")) {
            if (this.isAvailable(k)) continue;
            return false;
        }
        return true;
    }

    default public boolean isAvailable(Iterable<RequestLogAvailability> availabilities) {
        for (RequestLogAvailability k : Objects.requireNonNull(availabilities, "availabilities")) {
            if (this.isAvailable(k)) continue;
            return false;
        }
        return true;
    }

    default public void ensureAvailability(RequestLogAvailability availability) {
        if (!this.isAvailable(availability)) {
            throw new RequestLogAvailabilityException(availability.name());
        }
    }

    default public void ensureAvailability(RequestLogAvailability ... availabilities) {
        if (!this.isAvailable(availabilities)) {
            throw new RequestLogAvailabilityException(Arrays.toString((Object[])availabilities));
        }
    }

    default public void ensureAvailability(Iterable<RequestLogAvailability> properties) {
        if (!this.isAvailable(properties)) {
            throw new RequestLogAvailabilityException(properties.toString());
        }
    }

    public void addListener(RequestLogListener var1, RequestLogAvailability var2);

    public void addListener(RequestLogListener var1, RequestLogAvailability ... var2);

    public void addListener(RequestLogListener var1, Iterable<RequestLogAvailability> var2);

    public RequestContext context();

    public long requestStartTimeMillis();

    public long requestDurationNanos();

    public long requestLength();

    public Throwable requestCause();

    public long responseStartTimeMillis();

    public long responseDurationNanos();

    public long responseLength();

    public Throwable responseCause();

    public long totalDurationNanos();

    public Channel channel();

    public SessionProtocol sessionProtocol();

    public SerializationFormat serializationFormat();

    public Scheme scheme();

    public String host();

    public String method();

    public String path();

    public int statusCode();

    public Object requestEnvelope();

    public Object requestContent();

    public Object rawRequestContent();

    public Object responseEnvelope();

    public Object responseContent();

    public Object rawResponseContent();

    public String toStringRequestOnly();

    public String toStringResponseOnly();
}

