package org.xbib.helianthus.common.stream;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class AbortingSubscriber implements Subscriber<Object> {

    static final AbortingSubscriber INSTANCE = new AbortingSubscriber();

    private AbortingSubscriber() {
    }

    @Override
    public void onSubscribe(Subscription s) {
        s.cancel();
    }

    @Override
    public void onNext(Object o) {
    }

    @Override
    public void onError(Throwable t) {
    }

    @Override
    public void onComplete() {
    }
}
