/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common;

import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import org.xbib.helianthus.common.RequestContextAwareEventLoop;
import org.xbib.helianthus.common.RequestContextAwareExecutorService;
import org.xbib.helianthus.common.RequestContextThreadLocal;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.RequestLogBuilder;
import org.xbib.helianthus.common.util.SafeCloseable;

public interface RequestContext
extends AttributeMap {
    public static final Logger logger = Logger.getLogger(RequestContext.class.getName());

    public static <T extends RequestContext> T current() {
        Object ctx = RequestContextThreadLocal.get();
        if (ctx == null) {
            throw new IllegalStateException(RequestContext.class.getSimpleName() + " unavailable");
        }
        return ctx;
    }

    public static <T> T mapCurrent(Function<? super RequestContext, T> mapper, Supplier<T> defaultValueSupplier) {
        Object ctx = RequestContextThreadLocal.get();
        if (ctx != null) {
            return mapper.apply((RequestContext)ctx);
        }
        if (defaultValueSupplier != null) {
            return defaultValueSupplier.get();
        }
        return null;
    }

    public static SafeCloseable push(RequestContext ctx) {
        return RequestContext.push(ctx, true);
    }

    public static SafeCloseable push(RequestContext ctx, boolean runCallbacks) {
        Object oldCtx = RequestContextThreadLocal.getAndSet(ctx);
        if (oldCtx == ctx) {
            return () -> {};
        }
        if (runCallbacks) {
            ctx.invokeOnEnterCallbacks();
            if (oldCtx != null) {
                return () -> {
                    ctx.invokeOnExitCallbacks();
                    RequestContextThreadLocal.set(oldCtx);
                };
            }
            return () -> {
                ctx.invokeOnExitCallbacks();
                RequestContextThreadLocal.remove();
            };
        }
        if (oldCtx != null) {
            return () -> RequestContextThreadLocal.set(oldCtx);
        }
        return RequestContextThreadLocal::remove;
    }

    public SessionProtocol sessionProtocol();

    public <A extends SocketAddress> A remoteAddress();

    public <A extends SocketAddress> A localAddress();

    public SSLSession sslSession();

    public String method();

    public String path();

    public <T> T request();

    public RequestLog log();

    public RequestLogBuilder logBuilder();

    public Iterator<Attribute<?>> attrs();

    public EventLoop eventLoop();

    default public EventLoop contextAwareEventLoop() {
        return new RequestContextAwareEventLoop(this, this.eventLoop());
    }

    default public Executor makeContextAware(Executor executor) {
        return runnable -> executor.execute(this.makeContextAware(runnable));
    }

    default public ExecutorService makeContextAware(ExecutorService executor) {
        return new RequestContextAwareExecutorService(this, executor);
    }

    public <T> Callable<T> makeContextAware(Callable<T> var1);

    public Runnable makeContextAware(Runnable var1);

    public <T, R> Function<T, R> makeContextAware(Function<T, R> var1);

    public <T, U, V> BiFunction<T, U, V> makeContextAware(BiFunction<T, U, V> var1);

    public <T> Consumer<T> makeContextAware(Consumer<T> var1);

    public <T, U> BiConsumer<T, U> makeContextAware(BiConsumer<T, U> var1);

    public <T extends Future<?>> GenericFutureListener<T> makeContextAware(GenericFutureListener<T> var1);

    public <T> CompletionStage<T> makeContextAware(CompletionStage<T> var1);

    default public <T> CompletableFuture<T> makeContextAware(CompletableFuture<T> future) {
        return this.makeContextAware((CompletionStage<T>)future).toCompletableFuture();
    }

    public void onEnter(Runnable var1);

    public void onExit(Runnable var1);

    public void invokeOnEnterCallbacks();

    public void invokeOnExitCallbacks();
}

