/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import io.netty.handler.codec.ValueConverter;
import org.xbib.helianthus.common.http.HeaderDateTimeFormat;

final class StringValueConverter
implements ValueConverter<String> {
    static final StringValueConverter INSTANCE = new StringValueConverter();

    private StringValueConverter() {
    }

    public String convertObject(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String convertInt(int value) {
        return String.valueOf(value);
    }

    public String convertLong(long value) {
        return String.valueOf(value);
    }

    public String convertDouble(double value) {
        return String.valueOf(value);
    }

    public String convertChar(char value) {
        return String.valueOf(value);
    }

    public String convertBoolean(boolean value) {
        return String.valueOf(value);
    }

    public String convertFloat(float value) {
        return String.valueOf(value);
    }

    public boolean convertToBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    public String convertByte(byte value) {
        return String.valueOf(value & 0xFF);
    }

    public byte convertToByte(String value) {
        return (byte)value.charAt(0);
    }

    public char convertToChar(String value) {
        return value.charAt(0);
    }

    public String convertShort(short value) {
        return String.valueOf(value);
    }

    public short convertToShort(String value) {
        return Short.valueOf(value);
    }

    public int convertToInt(String value) {
        return Integer.parseInt(value);
    }

    public long convertToLong(String value) {
        return Long.parseLong(value);
    }

    public String convertTimeMillis(long value) {
        return HeaderDateTimeFormat.format(value);
    }

    public long convertToTimeMillis(String value) {
        return HeaderDateTimeFormat.parse(value).toEpochMilli();
    }

    public float convertToFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public double convertToDouble(String value) {
        return Double.valueOf(value);
    }
}

