/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.RpcResponse;
import org.xbib.helianthus.common.Scheme;
import org.xbib.helianthus.common.SerializationFormat;
import org.xbib.helianthus.common.SessionProtocol;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.RequestLogAvailability;
import org.xbib.helianthus.common.logging.RequestLogAvailabilitySet;
import org.xbib.helianthus.common.logging.RequestLogBuilder;
import org.xbib.helianthus.common.logging.RequestLogListener;
import org.xbib.helianthus.common.logging.RequestLogListenerInvoker;
import org.xbib.helianthus.common.util.TextFormatter;

public class DefaultRequestLog
implements RequestLog,
RequestLogBuilder {
    private static final AtomicIntegerFieldUpdater<DefaultRequestLog> flagsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultRequestLog.class, "flags");
    private static final int FLAGS_REQUEST_END_WITHOUT_CONTENT = RequestLogAvailability.REQUEST_END.setterFlags() & ~RequestLogAvailability.REQUEST_CONTENT.setterFlags();
    private static final int FLAGS_RESPONSE_END_WITHOUT_CONTENT = RequestLogAvailability.RESPONSE_END.setterFlags() & ~RequestLogAvailability.RESPONSE_CONTENT.setterFlags();
    private static final int STRING_BUILDER_CAPACITY = 512;
    private final RequestContext ctx;
    private volatile int flags;
    private final List<ListenerEntry> listeners = new ArrayList<ListenerEntry>(4);
    private volatile boolean requestContentDeferred;
    private volatile boolean responseContentDeferred;
    private long requestStartTimeMillis;
    private long requestStartTimeNanos;
    private long requestEndTimeNanos;
    private long requestLength;
    private Throwable requestCause;
    private long responseStartTimeMillis;
    private long responseStartTimeNanos;
    private long responseEndTimeNanos;
    private long responseLength;
    private Throwable responseCause;
    private Channel channel;
    private SessionProtocol sessionProtocol;
    private SerializationFormat serializationFormat = SerializationFormat.NONE;
    private String host;
    private String method;
    private String path;
    private int statusCode = -1;
    private Object requestEnvelope;
    private Object responseEnvelope;
    private Object requestContent;
    private Object rawRequestContent;
    private Object responseContent;
    private Object rawResponseContent;
    private volatile int requestStrFlags = -1;
    private volatile int responseStrFlags = -1;
    private String requestStr;
    private String responseStr;

    public DefaultRequestLog(RequestContext ctx) {
        this.ctx = Objects.requireNonNull(ctx, "ctx");
    }

    @Override
    public Set<RequestLogAvailability> availabilities() {
        return RequestLogAvailabilitySet.of(this.flags);
    }

    @Override
    public boolean isAvailable(RequestLogAvailability availability) {
        return this.isAvailable(availability.getterFlags());
    }

    @Override
    public boolean isAvailable(RequestLogAvailability ... availabilities) {
        return this.isAvailable(DefaultRequestLog.getterFlags(availabilities));
    }

    @Override
    public boolean isAvailable(Iterable<RequestLogAvailability> availabilities) {
        return this.isAvailable(DefaultRequestLog.getterFlags(availabilities));
    }

    private boolean isAvailable(int interestedFlags) {
        return (this.flags & interestedFlags) == interestedFlags;
    }

    private static boolean isAvailable(int flags, RequestLogAvailability availability) {
        int interestedFlags = availability.getterFlags();
        return (flags & interestedFlags) == interestedFlags;
    }

    private boolean isAvailabilityAlreadyUpdated(RequestLogAvailability availability) {
        return this.isAvailable(availability.setterFlags());
    }

    @Override
    public void addListener(RequestLogListener listener, RequestLogAvailability availability) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(availability, "availability");
        this.addListener(listener, availability.getterFlags());
    }

    @Override
    public void addListener(RequestLogListener listener, RequestLogAvailability ... availabilities) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(availabilities, "availabilities");
        this.addListener(listener, DefaultRequestLog.getterFlags(availabilities));
    }

    @Override
    public void addListener(RequestLogListener listener, Iterable<RequestLogAvailability> availabilities) {
        Objects.requireNonNull(listener, "listener");
        Objects.requireNonNull(availabilities, "availabilities");
        this.addListener(listener, DefaultRequestLog.getterFlags(availabilities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(RequestLogListener listener, int interestedFlags) {
        RequestLogListener[] satisfiedListeners;
        if (interestedFlags == 0) {
            throw new IllegalArgumentException("no availability specified");
        }
        if (this.isAvailable(interestedFlags)) {
            RequestLogListenerInvoker.invokeOnRequestLog(listener, this);
            return;
        }
        ListenerEntry e = new ListenerEntry(listener, interestedFlags);
        List<ListenerEntry> list = this.listeners;
        synchronized (list) {
            this.listeners.add(e);
            satisfiedListeners = this.removeSatisfiedListeners();
        }
        this.notifyListeners(satisfiedListeners);
    }

    private static int getterFlags(RequestLogAvailability[] availabilities) {
        int flags = 0;
        for (RequestLogAvailability a : availabilities) {
            flags |= a.getterFlags();
        }
        return flags;
    }

    private static int getterFlags(Iterable<RequestLogAvailability> availabilities) {
        int flags = 0;
        for (RequestLogAvailability a : availabilities) {
            flags |= a.getterFlags();
        }
        return flags;
    }

    @Override
    public RequestContext context() {
        return this.ctx;
    }

    @Override
    public void startRequest(Channel channel, SessionProtocol sessionProtocol, String host, String method, String path) {
        this.startRequest0(channel, sessionProtocol, host, method, path, true);
    }

    private void startRequest0(Channel channel, SessionProtocol sessionProtocol, String host, String method, String path, boolean updateAvailability) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.REQUEST_START)) {
            return;
        }
        this.requestStartTimeNanos = System.nanoTime();
        this.requestStartTimeMillis = System.currentTimeMillis();
        this.channel = channel;
        this.sessionProtocol = sessionProtocol;
        this.host = host;
        this.method = method;
        this.path = path;
        if (updateAvailability) {
            this.updateAvailability(RequestLogAvailability.REQUEST_START);
        }
    }

    @Override
    public long requestStartTimeMillis() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.requestStartTimeMillis;
    }

    @Override
    public long requestDurationNanos() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_END);
        return this.requestEndTimeNanos - this.requestStartTimeNanos;
    }

    @Override
    public Throwable requestCause() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_END);
        return this.requestCause;
    }

    @Override
    public Channel channel() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.channel;
    }

    @Override
    public SessionProtocol sessionProtocol() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.sessionProtocol;
    }

    @Override
    public String host() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.host;
    }

    @Override
    public String method() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.method;
    }

    @Override
    public String path() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_START);
        return this.path;
    }

    @Override
    public SerializationFormat serializationFormat() {
        this.ensureAvailability(RequestLogAvailability.SCHEME);
        return this.serializationFormat;
    }

    @Override
    public void serializationFormat(SerializationFormat serializationFormat) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.SCHEME)) {
            return;
        }
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        this.updateAvailability(RequestLogAvailability.SCHEME);
    }

    @Override
    public Scheme scheme() {
        this.ensureAvailability(RequestLogAvailability.SCHEME);
        return Scheme.of(this.serializationFormat, this.sessionProtocol);
    }

    @Override
    public long requestLength() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_END);
        return this.requestLength;
    }

    @Override
    public void requestLength(long requestLength) {
        if (requestLength < 0L) {
            throw new IllegalArgumentException("requestLength: " + requestLength + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogAvailability.REQUEST_END)) {
            return;
        }
        this.requestLength = requestLength;
    }

    @Override
    public void increaseRequestLength(long deltaBytes) {
        if (deltaBytes < 0L) {
            throw new IllegalArgumentException("deltaBytes: " + deltaBytes + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogAvailability.REQUEST_END)) {
            return;
        }
        this.requestLength += deltaBytes;
    }

    @Override
    public Object requestEnvelope() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_ENVELOPE);
        return this.requestEnvelope;
    }

    @Override
    public void requestEnvelope(Object requestEnvelope) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.REQUEST_ENVELOPE)) {
            return;
        }
        this.requestEnvelope = requestEnvelope;
        this.updateAvailability(RequestLogAvailability.REQUEST_ENVELOPE);
    }

    @Override
    public Object requestContent() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_CONTENT);
        return this.requestContent;
    }

    @Override
    public void requestContent(Object requestContent, Object rawRequestContent) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.REQUEST_CONTENT)) {
            return;
        }
        this.requestContent = requestContent;
        this.rawRequestContent = rawRequestContent;
        this.updateAvailability(RequestLogAvailability.REQUEST_CONTENT);
    }

    @Override
    public Object rawRequestContent() {
        this.ensureAvailability(RequestLogAvailability.REQUEST_CONTENT);
        return this.rawRequestContent;
    }

    @Override
    public void deferRequestContent() {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.REQUEST_CONTENT)) {
            return;
        }
        this.requestContentDeferred = true;
    }

    @Override
    public boolean isRequestContentDeferred() {
        return this.requestContentDeferred;
    }

    @Override
    public void endRequest() {
        this.endRequest0(null);
    }

    @Override
    public void endRequest(Throwable requestCause) {
        this.endRequest0(Objects.requireNonNull(requestCause, "requestCause"));
    }

    private void endRequest0(Throwable requestCause) {
        int flags;
        int n = flags = requestCause == null && this.requestContentDeferred ? FLAGS_REQUEST_END_WITHOUT_CONTENT : RequestLogAvailability.REQUEST_END.setterFlags();
        if (this.isAvailable(flags)) {
            return;
        }
        this.startRequest0(null, null, null, null, null, false);
        this.requestEndTimeNanos = System.nanoTime();
        this.requestCause = requestCause;
        this.updateAvailability(flags);
    }

    @Override
    public void startResponse() {
        this.startResponse0(true);
    }

    private void startResponse0(boolean updateAvailability) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.RESPONSE_START)) {
            return;
        }
        this.responseStartTimeNanos = System.nanoTime();
        this.responseStartTimeMillis = System.currentTimeMillis();
        if (updateAvailability) {
            this.updateAvailability(RequestLogAvailability.RESPONSE_START);
        }
    }

    @Override
    public long responseStartTimeMillis() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_START);
        return this.responseStartTimeMillis;
    }

    @Override
    public long responseDurationNanos() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_END);
        return this.responseEndTimeNanos - this.responseStartTimeNanos;
    }

    @Override
    public Throwable responseCause() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_END);
        return this.responseCause;
    }

    @Override
    public int statusCode() {
        this.ensureAvailability(RequestLogAvailability.STATUS_CODE);
        return this.statusCode;
    }

    @Override
    public void statusCode(int statusCode) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.STATUS_CODE)) {
            return;
        }
        this.statusCode = statusCode;
        this.updateAvailability(RequestLogAvailability.STATUS_CODE);
    }

    @Override
    public long responseLength() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_END);
        return this.responseLength;
    }

    @Override
    public void responseLength(long responseLength) {
        if (responseLength < 0L) {
            throw new IllegalArgumentException("responseLength: " + responseLength + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogAvailability.RESPONSE_END)) {
            return;
        }
        this.responseLength = responseLength;
    }

    @Override
    public void increaseResponseLength(long deltaBytes) {
        if (deltaBytes < 0L) {
            throw new IllegalArgumentException("deltaBytes: " + deltaBytes + " (expected: >= 0)");
        }
        if (this.isAvailable(RequestLogAvailability.RESPONSE_END)) {
            return;
        }
        this.responseLength += deltaBytes;
    }

    @Override
    public Object responseEnvelope() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_ENVELOPE);
        return this.responseEnvelope;
    }

    @Override
    public void responseEnvelope(Object responseEnvelope) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.RESPONSE_ENVELOPE)) {
            return;
        }
        this.responseEnvelope = responseEnvelope;
        this.updateAvailability(RequestLogAvailability.RESPONSE_ENVELOPE);
    }

    @Override
    public Object responseContent() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_CONTENT);
        return this.responseContent;
    }

    @Override
    public void responseContent(Object responseContent, Object rawResponseContent) {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.RESPONSE_CONTENT)) {
            return;
        }
        if (responseContent instanceof RpcResponse && !((RpcResponse)responseContent).isDone()) {
            throw new IllegalArgumentException("responseContent must be complete: " + responseContent);
        }
        this.responseContent = responseContent;
        this.rawResponseContent = rawResponseContent;
        this.updateAvailability(RequestLogAvailability.RESPONSE_CONTENT);
    }

    @Override
    public Object rawResponseContent() {
        this.ensureAvailability(RequestLogAvailability.RESPONSE_CONTENT);
        return this.rawResponseContent;
    }

    @Override
    public void deferResponseContent() {
        if (this.isAvailabilityAlreadyUpdated(RequestLogAvailability.RESPONSE_CONTENT)) {
            return;
        }
        this.responseContentDeferred = true;
    }

    @Override
    public boolean isResponseContentDeferred() {
        return this.responseContentDeferred;
    }

    @Override
    public void endResponse() {
        this.endResponse0(null);
    }

    @Override
    public void endResponse(Throwable responseCause) {
        this.endResponse0(Objects.requireNonNull(responseCause, "responseCause"));
    }

    private void endResponse0(Throwable responseCause) {
        int flags;
        int n = flags = responseCause == null && this.responseContentDeferred ? FLAGS_RESPONSE_END_WITHOUT_CONTENT : RequestLogAvailability.RESPONSE_END.setterFlags();
        if (this.isAvailable(flags)) {
            return;
        }
        this.startResponse0(false);
        this.responseEndTimeNanos = System.nanoTime();
        this.responseCause = responseCause;
        this.updateAvailability(flags);
    }

    @Override
    public long totalDurationNanos() {
        this.ensureAvailability(RequestLogAvailability.COMPLETE);
        return this.responseEndTimeNanos - this.requestStartTimeNanos;
    }

    private void updateAvailability(RequestLogAvailability a) {
        this.updateAvailability(a.setterFlags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAvailability(int flags) {
        block4: {
            RequestLogListener[] satisfiedListeners;
            int newAvailability;
            int oldAvailability;
            while (!flagsUpdater.compareAndSet(this, oldAvailability = this.flags, newAvailability = oldAvailability | flags)) {
            }
            if (oldAvailability == newAvailability) break block4;
            List<ListenerEntry> list = this.listeners;
            synchronized (list) {
                satisfiedListeners = this.removeSatisfiedListeners();
            }
            this.notifyListeners(satisfiedListeners);
        }
    }

    private RequestLogListener[] removeSatisfiedListeners() {
        if (this.listeners.isEmpty()) {
            return null;
        }
        int flags = this.flags;
        int maxNumListeners = this.listeners.size();
        Iterator<ListenerEntry> i = this.listeners.iterator();
        RequestLogListener[] satisfied = null;
        int numSatisfied = 0;
        do {
            ListenerEntry e = i.next();
            int interestedFlags = e.interestedFlags;
            if ((flags & interestedFlags) != interestedFlags) continue;
            i.remove();
            if (satisfied == null) {
                satisfied = new RequestLogListener[maxNumListeners];
            }
            satisfied[numSatisfied++] = e.listener;
        } while (i.hasNext());
        return satisfied;
    }

    private void notifyListeners(RequestLogListener[] listeners) {
        if (listeners == null) {
            return;
        }
        for (RequestLogListener l : listeners) {
            if (l == null) break;
            RequestLogListenerInvoker.invokeOnRequestLog(l, this);
        }
    }

    public String toString() {
        String req = this.toStringRequestOnly();
        String res = this.toStringResponseOnly();
        StringBuilder buf = new StringBuilder(5 + req.length() + 6 + res.length() + 1);
        return buf.append("{req=").append(req).append(", res=").append(res).append('}').toString();
    }

    @Override
    public String toStringRequestOnly() {
        int flags = this.flags & 0xFFFF;
        if (this.requestStrFlags == flags) {
            return this.requestStr;
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append('{');
        if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_START)) {
            buf.append("startTime=");
            TextFormatter.appendEpoch(buf, this.requestStartTimeMillis);
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_END)) {
                buf.append(", length=");
                TextFormatter.appendSize(buf, this.requestLength);
                buf.append(", duration=");
                TextFormatter.appendElapsed(buf, this.requestDurationNanos());
                if (this.requestCause != null) {
                    buf.append(", cause=").append(this.requestCause);
                }
            }
            buf.append(", scheme=");
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.SCHEME)) {
                buf.append(this.scheme().uriText());
            } else {
                buf.append(SerializationFormat.UNKNOWN.uriText()).append('+').append(this.sessionProtocol.uriText());
            }
            buf.append(", host=").append(this.host).append(", method=").append(this.method).append(", path=").append(this.path);
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_ENVELOPE) && this.requestEnvelope != null) {
                buf.append(", envelope=").append(this.requestEnvelope);
            }
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_CONTENT) && this.requestContent != null) {
                buf.append(", content=").append(this.requestContent);
            }
        }
        buf.append('}');
        this.requestStr = buf.toString();
        this.requestStrFlags = flags;
        return this.requestStr;
    }

    @Override
    public String toStringResponseOnly() {
        int flags = this.flags & 0xFFFF0000;
        if (this.responseStrFlags == flags) {
            return this.responseStr;
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append('{');
        if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.RESPONSE_START)) {
            buf.append("startTime=");
            TextFormatter.appendEpoch(buf, this.responseStartTimeMillis);
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.RESPONSE_END)) {
                buf.append(", length=");
                TextFormatter.appendSize(buf, this.responseLength);
                buf.append(", duration=");
                TextFormatter.appendElapsed(buf, this.responseDurationNanos());
                if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.REQUEST_START)) {
                    buf.append(", totalDuration=");
                    TextFormatter.appendElapsed(buf, this.totalDurationNanos());
                }
                if (this.responseCause != null) {
                    buf.append(", cause=").append(this.responseCause);
                }
            }
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.STATUS_CODE)) {
                buf.append(", statusCode=").append(this.statusCode);
            }
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.RESPONSE_ENVELOPE) && this.responseEnvelope != null) {
                buf.append(", envelope=").append(this.responseEnvelope);
            }
            if (DefaultRequestLog.isAvailable(flags, RequestLogAvailability.RESPONSE_CONTENT) && this.responseContent != null) {
                buf.append(", content=").append(this.responseContent);
            }
        }
        buf.append('}');
        this.responseStr = buf.toString();
        this.responseStrFlags = flags;
        return this.responseStr;
    }

    private static final class ListenerEntry {
        final RequestLogListener listener;
        final int interestedFlags;

        ListenerEntry(RequestLogListener listener, int interestedFlags) {
            this.listener = listener;
            this.interestedFlags = interestedFlags;
        }
    }
}

