/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.internal;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, AtomicReferenceArray> updater = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, AtomicReferenceArray.class, "attributes");
    private static final int BUCKET_SIZE = 4;
    private static final int MASK = 3;
    volatile AtomicReferenceArray<DefaultAttribute<?>> attributes;

    private static int index(AttributeKey<?> key) {
        return key.id() & 3;
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        int i;
        DefaultAttribute<Object> head;
        if (key == null) {
            throw new NullPointerException("key");
        }
        AtomicReferenceArray<DefaultAttribute<Object>> attributes = this.attributes;
        if (attributes == null && !updater.compareAndSet(this, null, attributes = new AtomicReferenceArray(4))) {
            attributes = this.attributes;
        }
        if ((head = attributes.get(i = DefaultAttributeMap.index(key))) == null) {
            head = new DefaultAttribute<T>(key);
            if (attributes.compareAndSet(i, null, head)) {
                return head;
            }
            head = attributes.get(i);
        }
        DefaultAttribute<?> defaultAttribute = head;
        synchronized (defaultAttribute) {
            DefaultAttribute curr = head;
            while (true) {
                if (!curr.removed && curr.key == key) {
                    return curr;
                }
                DefaultAttribute next = curr.next;
                if (next == null) {
                    DefaultAttribute<T> attr = new DefaultAttribute<T>(head, key);
                    curr.next = (DefaultAttribute)attr;
                    ((DefaultAttribute)attr).prev = curr;
                    return attr;
                }
                curr = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean hasAttr(AttributeKey<T> key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        AtomicReferenceArray<DefaultAttribute<?>> attributes = this.attributes;
        if (attributes == null) {
            return false;
        }
        int i = DefaultAttributeMap.index(key);
        DefaultAttribute<?> head = attributes.get(i);
        if (head == null) {
            return false;
        }
        if (((DefaultAttribute)head).key == key && !((DefaultAttribute)head).removed) {
            return true;
        }
        DefaultAttribute<?> defaultAttribute = head;
        synchronized (defaultAttribute) {
            DefaultAttribute curr = ((DefaultAttribute)head).next;
            while (curr != null) {
                if (!curr.removed && curr.key == key) {
                    return true;
                }
                curr = curr.next;
            }
            return false;
        }
    }

    public Iterator<Attribute<?>> attrs() {
        AtomicReferenceArray<DefaultAttribute<?>> attributes = this.attributes;
        if (attributes == null) {
            return Collections.emptyIterator();
        }
        return new IteratorImpl(attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Attribute<?>> i = this.attrs();
        while (i.hasNext()) {
            Attribute<?> a = i.next();
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(a.key().name()).append('=').append(a.get());
        }
        return sb.toString();
    }

    private static final class IteratorImpl
    implements Iterator<Attribute<?>> {
        private final AtomicReferenceArray<DefaultAttribute<?>> attributes;
        private int i = -1;
        private DefaultAttribute<?> next;

        IteratorImpl(AtomicReferenceArray<DefaultAttribute<?>> attributes) {
            this.attributes = attributes;
            this.next = this.findNext(null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Attribute<?> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            DefaultAttribute<?> next = this.next;
            this.next = this.findNext(((DefaultAttribute)next).next);
            return next;
        }

        private DefaultAttribute<?> findNext(DefaultAttribute<?> next) {
            boolean found;
            block0: do {
                if (next == null) {
                    ++this.i;
                    while (this.i < this.attributes.length()) {
                        DefaultAttribute<?> attr = this.attributes.get(this.i);
                        if (attr != null) {
                            next = attr;
                            break;
                        }
                        ++this.i;
                    }
                    if (this.i == this.attributes.length()) {
                        return null;
                    }
                }
                found = false;
                while (next != null && ((DefaultAttribute)next).removed) {
                    if ((next = ((DefaultAttribute)next).next) != null) continue;
                    found = true;
                    continue block0;
                }
            } while (found);
            return next;
        }
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final long serialVersionUID = -2661411462200283011L;
        private final DefaultAttribute<?> head;
        private final AttributeKey<T> key;
        private DefaultAttribute<?> prev;
        private DefaultAttribute<?> next;
        private volatile boolean removed;

        DefaultAttribute(DefaultAttribute<?> head, AttributeKey<T> key) {
            this.head = head;
            this.key = key;
        }

        DefaultAttribute(AttributeKey<T> key) {
            this.head = this;
            this.key = key;
        }

        public AttributeKey<T> key() {
            return this.key;
        }

        public T setIfAbsent(T value) {
            while (!this.compareAndSet(null, value)) {
                Object old = this.get();
                if (old == null) continue;
                return (T)old;
            }
            return null;
        }

        public T getAndRemove() {
            this.removed = true;
            T oldValue = this.getAndSet(null);
            this.remove0();
            return oldValue;
        }

        public void remove() {
            this.removed = true;
            this.set(null);
            this.remove0();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove0() {
            DefaultAttribute<?> defaultAttribute = this.head;
            synchronized (defaultAttribute) {
                if (this.prev != null) {
                    this.prev.next = this.next;
                    if (this.next != null) {
                        this.next.prev = this.prev;
                    }
                    this.prev = null;
                    this.next = null;
                }
            }
        }
    }
}

