package org.xbib.helianthus.common;

import static java.util.Objects.requireNonNull;

import java.util.List;

public class AbstractRpcRequest implements RpcRequest {

    private final Class<?> serviceType;
    private final String method;
    private final List<Object> args;

    protected AbstractRpcRequest(Class<?> serviceType, String method, List<Object> args) {
        this.serviceType = requireNonNull(serviceType, "serviceType");
        this.method = requireNonNull(method, "method");
        this.args = args;
    }

    @Override
    public final Class<?> serviceType() {
        return serviceType;
    }

    @Override
    public final String method() {
        return method;
    }

    @Override
    public final List<Object> params() {
        return args;
    }

    @Override
    public int hashCode() {
        return method().hashCode() * 31 + params().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof AbstractRpcRequest)) {
            return false;
        }

        final AbstractRpcRequest that = (AbstractRpcRequest) obj;
        return method().equals(that.method()) &&
                params().equals(that.params());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractRpcRequest:serviceType=")
                .append(simpleServiceName())
                .append(",method=")
                .append(method())
                .append(",args=")
                .append(params());
        return sb.toString();
    }

    protected final String simpleServiceName() {
        final Class<?> serviceType = serviceType();
        final String fqcn = serviceType.getName();
        final int lastDot = fqcn.lastIndexOf('.');
        return lastDot < 0 ? fqcn : fqcn.substring(lastDot + 1);
    }
}
