package org.xbib.helianthus.common;

import org.xbib.helianthus.common.util.Exceptions;

/**
 * A {@link RuntimeException} raised when the connection to the remote peer has been closed unexpectedly.
 */
public final class ClosedSessionException extends RuntimeException {

    private static final long serialVersionUID = -78487475521731580L;

    private static final ClosedSessionException INSTANCE = Exceptions.clearTrace(new ClosedSessionException());

    /**
     * Creates a new instance.
     */
    private ClosedSessionException() {
    }

    public static ClosedSessionException get() {
        return Exceptions.isVerbose() ? new ClosedSessionException() : INSTANCE;
    }
}
