package org.xbib.helianthus.common;

import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.xbib.helianthus.common.logging.RequestLog;
import org.xbib.helianthus.common.logging.RequestLogBuilder;

import javax.net.ssl.SSLSession;
import java.net.SocketAddress;
import java.util.Iterator;

import static java.util.Objects.requireNonNull;

/**
 * Wraps an existing {@link RequestContext}.
 *
 * @param <T> the self type
 */
public abstract class RequestContextWrapper<T extends RequestContext> extends AbstractRequestContext {

    private final T delegate;

    /**
     * Creates a new instance.
     */
    protected RequestContextWrapper(T delegate) {
        this.delegate = requireNonNull(delegate, "delegate");
    }

    /**
     * Returns the delegate context.
     */
    protected final T delegate() {
        return delegate;
    }

    @Override
    public SessionProtocol sessionProtocol() {
        return delegate().sessionProtocol();
    }

    @Override
    public <A extends SocketAddress> A remoteAddress() {
        return delegate().remoteAddress();
    }

    @Override
    public <A extends SocketAddress> A localAddress() {
        return delegate().localAddress();
    }

    @Override
    public SSLSession sslSession() {
        return delegate().sslSession();
    }

    @Override
    public String method() {
        return delegate().method();
    }

    @Override
    public String path() {
        return delegate().path();
    }

    @Override
    public <T> T request() {
        return delegate().request();
    }

    @Override
    public RequestLog log() {
        return delegate().log();
    }

    @Override
    public RequestLogBuilder logBuilder() {
        return delegate().logBuilder();
    }

    @Override
    public Iterator<Attribute<?>> attrs() {
        return delegate().attrs();
    }

    @Override
    public EventLoop eventLoop() {
        return delegate().eventLoop();
    }

    @Override
    public void onEnter(Runnable callback) {
        delegate().onEnter(callback);
    }

    @Override
    public void onExit(Runnable callback) {
        delegate().onExit(callback);
    }

    @Override
    public void invokeOnEnterCallbacks() {
        delegate().invokeOnEnterCallbacks();
    }

    @Override
    public void invokeOnExitCallbacks() {
        delegate().invokeOnExitCallbacks();
    }

    @Override
    public <V> Attribute<V> attr(AttributeKey<V> key) {
        return delegate().attr(key);
    }

    @Override
    public <V> boolean hasAttr(AttributeKey<V> key) {
        return delegate().hasAttr(key);
    }
}
