package org.xbib.helianthus.common;

import org.xbib.helianthus.common.stream.StreamMessage;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface Response {
    default CompletableFuture<?> closeFuture() {
        if (this instanceof StreamMessage) {
            return ((StreamMessage<?>) this).closeFuture();
        }
        if (this instanceof CompletionStage) {
            return ((CompletionStage<?>) this).toCompletableFuture();
        }
        throw new IllegalStateException("response must be a " + StreamMessage.class.getSimpleName() + " or a " +
                        CompletionStage.class.getSimpleName() + ": " + getClass().getName());
    }
}
