package org.xbib.helianthus.common.http;

import java.util.List;

final class DefaultAggregatedHttpMessage implements AggregatedHttpMessage {

    private final List<HttpHeaders> informationals;
    private final HttpHeaders headers;
    private final HttpData content;
    private final HttpHeaders trailingHeaders;
    private final String followUrl;

    DefaultAggregatedHttpMessage(List<HttpHeaders> informationals, HttpHeaders headers,
                                 HttpData content, HttpHeaders trailingHeaders, String followUrl) {
        this.informationals = informationals;
        this.headers = headers;
        this.content = content;
        this.trailingHeaders = trailingHeaders;
        this.followUrl = followUrl;
    }

    @Override
    public List<HttpHeaders> informationals() {
        return informationals;
    }

    @Override
    public HttpHeaders headers() {
        return headers;
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return trailingHeaders;
    }

    @Override
    public HttpData content() {
        return content;
    }

    @Override
    public String followUrl() {
        return followUrl;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultAggregatedHttpMessage:");

        if (!informationals().isEmpty()) {
            sb.append("informationals=").append(informationals());
        }
        sb.append(",headers=").append(headers())
                .append(",content=").append(content());

        if (!trailingHeaders().isEmpty()) {
            sb.append(",trailingheaders=").append(trailingHeaders());
        }

        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof DefaultAggregatedHttpMessage)) {
            return false;
        }

        final DefaultAggregatedHttpMessage that = (DefaultAggregatedHttpMessage) obj;

        return informationals.equals(that.informationals) &&
                headers.equals(that.headers) &&
                content.equals(that.content) &&
                trailingHeaders.equals(that.trailingHeaders);
    }

    @Override
    public int hashCode() {
        int result = informationals.hashCode();
        result = 31 * result + headers.hashCode();
        result = 31 * result + content.hashCode();
        result = 31 * result + trailingHeaders.hashCode();
        return result;
    }
}
