package org.xbib.helianthus.common.logging;

import org.xbib.helianthus.common.RequestContext;
import org.xbib.helianthus.common.util.SafeCloseable;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Utility methods that invokes the callback methods of {@link RequestLogListener} safely.
 *
 * <p>They catch the exceptions raised by the callback methods and log them at WARN level.
 */
public final class RequestLogListenerInvoker {

    private static final Logger logger = Logger.getLogger(RequestLogListenerInvoker.class.getName());

    private RequestLogListenerInvoker() {
    }

    /**
     * Invokes {@link RequestLogListener#onRequestLog(RequestLog)}.
     */
    @SuppressWarnings("try")
    public static void invokeOnRequestLog(RequestLogListener listener, RequestLog log) {
        try (SafeCloseable ignored = RequestContext.push(log.context())) {
            listener.onRequestLog(log);
        } catch (Throwable e) {
            logger.log(Level.WARNING, "onRequestLog() failed with an exception:", e);
        }
    }

}
