package org.xbib.helianthus.common.stream;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.xbib.helianthus.common.util.Exceptions;

/**
 * A {@link RuntimeException} that is raised to notify {@link StreamMessage#closeFuture()} when a
 * {@link Subscriber} has cancelled its {@link Subscription}.
 */
public final class CancelledSubscriptionException extends RuntimeException {

    private static final long serialVersionUID = -7815958463104921571L;

    private static final CancelledSubscriptionException INSTANCE =
            Exceptions.clearTrace(new CancelledSubscriptionException());

    private CancelledSubscriptionException() {
    }

    public static CancelledSubscriptionException get() {
        return Exceptions.isVerbose() ? new CancelledSubscriptionException() : INSTANCE;
    }
}
