package org.xbib.helianthus.common.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class CompletionActions {

    private static final Logger logger = Logger.getLogger(CompletionActions.class.getName());

    private CompletionActions() {
    }


    /**
     * Logs the specified {@link Throwable}. For example:
     * <pre>{@code
     * CompletableFuture<?> f = ...;
     * f.exceptionally(CompletionActions::log);
     * }</pre>
     *
     * @return {@code null}
     */
    public static <T> T log(Throwable cause) {
        logger.log(Level.WARNING, "Unexpected exception from a completion action:", cause);
        return null;
    }

}
