/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.http;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;
import org.xbib.helianthus.common.Request;
import org.xbib.helianthus.common.http.AggregatedHttpMessage;
import org.xbib.helianthus.common.http.DefaultHttpRequest;
import org.xbib.helianthus.common.http.HttpHeaders;
import org.xbib.helianthus.common.http.HttpMethod;
import org.xbib.helianthus.common.http.HttpObject;
import org.xbib.helianthus.common.http.HttpRequestAggregator;
import org.xbib.helianthus.common.http.PublisherBasedHttpRequest;
import org.xbib.helianthus.common.stream.StreamMessage;

public interface HttpRequest
extends Request,
StreamMessage<HttpObject> {
    public static HttpRequest of(HttpHeaders headers, Publisher<? extends HttpObject> publisher) {
        return new PublisherBasedHttpRequest(headers, true, publisher);
    }

    public static HttpRequest of(HttpHeaders headers) {
        DefaultHttpRequest req = new DefaultHttpRequest(headers);
        req.close();
        return req;
    }

    public HttpHeaders headers();

    public boolean isKeepAlive();

    default public String scheme() {
        return this.headers().scheme();
    }

    default public HttpRequest scheme(String scheme) {
        this.headers().scheme(scheme);
        return this;
    }

    default public HttpMethod method() {
        return this.headers().method();
    }

    default public HttpRequest method(HttpMethod method) {
        this.headers().method(method);
        return this;
    }

    default public String path() {
        return this.headers().path();
    }

    default public HttpRequest path(String path) {
        this.headers().path(path);
        return this;
    }

    default public String authority() {
        return this.headers().authority();
    }

    default public HttpRequest authority(String authority) {
        this.headers().authority(authority);
        return this;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregate() {
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        this.subscribe(new HttpRequestAggregator(this, future));
        return future;
    }

    default public CompletableFuture<AggregatedHttpMessage> aggregate(Executor executor) {
        CompletableFuture<AggregatedHttpMessage> future = new CompletableFuture<AggregatedHttpMessage>();
        this.subscribe(new HttpRequestAggregator(this, future), executor);
        return future;
    }
}

