/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.helianthus.common.logging;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xbib.helianthus.common.logging.RequestLogAvailability;

final class RequestLogAvailabilitySet
extends AbstractSet<RequestLogAvailability> {
    private static final Map<Integer, RequestLogAvailabilitySet> map = new HashMap<Integer, RequestLogAvailabilitySet>();
    private final int flags;
    private final RequestLogAvailability[] values;

    static RequestLogAvailabilitySet of(int flags) {
        RequestLogAvailabilitySet availabilities = map.get(flags);
        assert (availabilities != null);
        return availabilities;
    }

    private RequestLogAvailabilitySet(int flags) {
        this.flags = flags;
        ArrayList<RequestLogAvailability> values = new ArrayList<RequestLogAvailability>();
        for (RequestLogAvailability v : RequestLogAvailability.values()) {
            if ((flags & v.getterFlags()) != flags) continue;
            values.add(v);
        }
        this.values = values.toArray(new RequestLogAvailability[values.size()]);
    }

    @Override
    public Iterator<RequestLogAvailability> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean contains(Object e) {
        if (!(e instanceof RequestLogAvailability)) {
            return false;
        }
        int flags = ((RequestLogAvailability)((Object)e)).getterFlags();
        return (this.flags & flags) == flags;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return Arrays.toString((Object[])this.values);
    }

    static {
        RequestLogAvailability[] values = RequestLogAvailability.values();
        int end = (int)Math.pow(2.0, values.length);
        for (int i = 0; i < end; ++i) {
            int flags = 0;
            for (RequestLogAvailability v : values) {
                if ((i & 1 << v.ordinal()) == 0) continue;
                flags |= v.getterFlags();
            }
            if (map.containsKey(flags)) continue;
            map.put(flags, new RequestLogAvailabilitySet(flags));
        }
    }
}

