package org.xbib.interlibrary.z.hbz;

import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.search.cql.CQLRequest;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.z.AbstractZCQLService;
import org.xbib.interlibrary.z.ZClientHelper;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 */
public class CQLService extends AbstractZCQLService {

    private static final Logger logger = Logger.getLogger(CQLService.class.getName());

    private final Map<String, Object> country;

    private final Map<String, Object> language;

    protected CQLService(Settings settings,
                         ServiceArguments arguments,
                         ZClientHelper client) {
        super(settings, arguments, client);
        try {
            country = getMap("/org/xbib/interlibrary/z/hbz/country.json");
            language = getMap("/org/xbib/interlibrary/z/hbz/language.json");
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        logger.log(Level.INFO, () -> "service up " + this);
    }

    @Override
    protected Object processSearchResult(InputStream inputStream) {
        String format = client.getSettings().get("connection.format");
        String type = client.getSettings().get("connection.type");
        Charset charset = Charset.forName(client.getSettings().get("connection.encoding"));
        Marc.Builder marcBuilder = Marc.builder()
                .setFormat(format)
                .setType(type)
                .setInputStream(inputStream)
                .setCharset(charset);
        List<Map<String, Object>> list = new ArrayList<>();
        for (MarcRecord marcRecord : marcBuilder.iterable()) {
            logger.log(Level.FINE, () -> "result: record = " + marcRecord);
            Map<String, Object> map = new LinkedHashMap<>();
            putIf(map, "id", extractIdentifier(marcRecord));
            putIf(map, "creator", extractCreators(marcRecord));
            putIf(map, "title", extractTitle(marcRecord));
            putIf(map, "country", extractCountry(marcRecord));
            putIf(map, "language", extractLanguage(marcRecord));
            putIf(map, "publishedAt", extractPublishedAt(marcRecord));
            putIf(map, "publishedBy", extractPublishedBy(marcRecord));
            putIf(map, "publishedOn", extractPublishedOn(marcRecord));
            putIf(map, "issn", extractISSN(marcRecord));
            putIf(map, "isbn", extractISBN(marcRecord));
            putIf(map, "zdb", extractZDB(marcRecord));
            putIf(map, "firstdate", extractFirstDate(marcRecord));
            putIf(map, "format", extractFormatCodes(marcRecord));
            map.put("service", extractServices(marcRecord));
            map.put("links", extractLinks(marcRecord));
            list.add(map);
        }
        return list.size() == 1 ? list.get(0) : list;
    }

    @Override
    protected String getIdentifierField() {
        return "001";
    }

    @Override
    protected List<String> getCreatorFields() {
        return creatorFields;
    }

    @Override
    protected List<String> getTitleFields() {
        return titleFields;
    }

    @Override
    protected String getCountryField() {
        return "036";
    }

    @Override
    protected Map<String, Object> getCountryMap() {
        return country;
    }

    @Override
    protected String getLanguageField() {
        return "037";
    }

    @Override
    protected Map<String, Object> getLanguageMap() {
        return language;
    }

    @Override
    public String getName() {
        return "HBZ";
    }

    @Override
    public CQLRequest validate(CQLRequest request) {
        return request;
    }

    private static final List<String> creatorFields = Arrays.asList(
            "100", "104", "108", "112", "116",
            "120", "124", "128", "132", "136",
            "140", "144", "148", "152", "156",
            "160", "164", "168", "172", "176",
            "180", "184", "188", "192", "196",
            "200", "204", "208", "212", "216",
            "220", "224", "228", "232", "236",
            "240", "244", "248", "252", "256",
            "260", "264", "268", "272", "276",
            "280", "284", "288", "292", "296");

    private static final List<String> titleFields = Arrays.asList(
            "310", "331", "335", "359", "360"
    );

    @Override
    public String toString() {
        return super.toString() + "[" + getName() + "]";
    }
}
