package org.xbib.interlibrary.z.hbz;

import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.z.ZClientHelper;

public class PQFServiceProvider implements org.xbib.interlibrary.action.search.pqf.PQFServiceProvider {

    PQFService pqfService;

    @Override
    public org.xbib.interlibrary.action.search.pqf.PQFService createService(Settings settings,
                                                                            String providerName,
                                                                            Settings providerSettings,
                                                                            ServiceArguments arguments) {
        if (Client.client == null) {
            Client.client = new ZClientHelper(settings.getAsSettings("z3950." + providerName));
        }
        if (pqfService == null) {
            pqfService = new PQFService(providerSettings, arguments, Client.client);
        }
        return pqfService;
    }
}
