package org.xbib.interlibrary.z.hbz;

import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.z.ZClientHelper;

public class SearchServiceProvider implements org.xbib.interlibrary.action.search.SearchServiceProvider {

    SearchService searchService;

    @Override
    public SearchService createService(Settings settings,
                                       String providerName,
                                       Settings providerSettings,
                                       ServiceArguments arguments) {
        if (Client.client == null) {
            Client.client = new ZClientHelper(settings.getAsSettings("z3950." + providerName));
        }
        if (searchService == null) {
            searchService = new SearchService(providerSettings, arguments, Client.client);
        }
        return searchService;
    }
}
