/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.z.hbz;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.avail.AvailRequest;
import org.xbib.interlibrary.action.avail.AvailResponse;
import org.xbib.interlibrary.api.Library;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.common.util.MultiMap;
import org.xbib.interlibrary.z.AbstractZAvailService;
import org.xbib.interlibrary.z.ZClientHelper;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;

public class AvailService
extends AbstractZAvailService {
    private static final Logger logger = Logger.getLogger(AvailService.class.getName());
    private final Map<String, Object> country;
    private final Map<String, Object> language;
    private final Map<String, Object> monographcodes;
    private final Map<String, Object> serialcodes;
    private final Map<String, Object> statuscodes;
    private static final List<String> creatorFields = Arrays.asList("100", "104", "108", "112", "116", "120", "124", "128", "132", "136", "140", "144", "148", "152", "156", "160", "164", "168", "172", "176", "180", "184", "188", "192", "196", "200", "204", "208", "212", "216", "220", "224", "228", "232", "236", "240", "244", "248", "252", "256", "260", "264", "268", "272", "276", "280", "284", "288", "292", "296");
    private static final List<String> titleFields = Arrays.asList("310", "331", "335", "359", "360");

    protected AvailService(Settings settings, ServiceArguments arguments, ZClientHelper client) {
        super(settings, arguments, client);
        try {
            this.country = AvailService.getMap((String)"/org/xbib/interlibrary/z/hbz/country.json");
            this.language = AvailService.getMap((String)"/org/xbib/interlibrary/z/hbz/language.json");
            this.monographcodes = AvailService.getMap((String)"/org/xbib/interlibrary/z/hbz/monographcodes.json");
            this.serialcodes = AvailService.getMap((String)"/org/xbib/interlibrary/z/hbz/serialcodes.json");
            this.statuscodes = AvailService.getMap((String)"/org/xbib/interlibrary/z/hbz/status.json");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected List<String> getServices() {
        return Arrays.asList("HBZ", "hbz");
    }

    protected String getIdentifierField() {
        return "001";
    }

    protected List<String> getCreatorFields() {
        return creatorFields;
    }

    protected List<String> getTitleFields() {
        return titleFields;
    }

    protected String getCountryField() {
        return "036";
    }

    protected Map<String, Object> getCountryMap() {
        return this.country;
    }

    protected String getLanguageField() {
        return "037";
    }

    protected Map<String, Object> getLanguageMap() {
        return this.language;
    }

    protected Map<String, Object> getMonographCodes() {
        return this.monographcodes;
    }

    protected Map<String, Object> getSerialCodes() {
        return this.serialcodes;
    }

    protected Map<String, Object> getStatusCodes() {
        return this.statuscodes;
    }

    protected void processAvailServices(AvailRequest request, InputStream inputStream, MultiMap<String, Map<String, Object>> multiMap, AvailResponse response) {
        String format = this.client.getSettings().get("connection.format");
        String type = this.client.getSettings().get("connection.type");
        Charset charset = Charset.forName(this.client.getSettings().get("connection.encoding"));
        Marc.Builder builder = Marc.builder().setFormat(format).setType(type).setInputStream(inputStream).setCharset(charset);
        Iterator marcRecordIterator = builder.recordIterator();
        while (marcRecordIterator.hasNext()) {
            MarcRecord marcRecord = (MarcRecord)marcRecordIterator.next();
            if (request.isBibliographicDescriptionEnabled().booleanValue()) {
                response.getBibliographicDescription().clear();
                response.getBibliographicDescription().putAll(marcRecord);
            }
            logger.log(Level.FINE, () -> "avail: record = " + marcRecord);
            String sourceid = ((MarcField)marcRecord.getFields("001").get(0)).getValue();
            String carrierType = this.isOnline(marcRecord) ? "online resource" : "volume";
            for (MarcField marcField : marcRecord.getFields("088")) {
                List codes;
                LinkedHashMap<String, ArrayList<Map<String, Object>>> info = new LinkedHashMap<String, ArrayList<Map<String, Object>>>();
                String sigel = marcField.getFirstSubfieldValue("a");
                StringBuilder sb = new StringBuilder();
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                Map<String, Object> location = new HashMap<String, Object>();
                LinkedHashMap<String, Object> service = new LinkedHashMap<String, Object>();
                for (MarcField.Subfield subfield : marcField.getSubfields()) {
                    location = this.makeLocation(subfield, location, sb, list);
                }
                if (!location.isEmpty()) {
                    list.add(location);
                }
                info.put("location", list);
                service.put("info", info);
                String isil = this.interlibraryConfiguration.normalizeLibraryIdentifier(sigel);
                if (isil == null) continue;
                service.put("isil", isil);
                Library library = (Library)this.interlibraryConfiguration.getLibraries().get(isil);
                if (library != null) {
                    service.put("name", library.getName());
                    service.put("domain", library.getDomain().getName());
                    service.put("organization", library.getDomain().getOrganization());
                }
                service.put("carriertype", carrierType);
                service.put("type", "interlibrary");
                String status = marcField.getFirstSubfieldValue("e");
                if (status != null && (codes = (List)this.getStatusCodes().get(status)) != null) {
                    service.put("mode", codes);
                    if (codes.contains("none")) {
                        service.put("type", "noninterlibrary");
                    }
                }
                service.put("source", this.name);
                service.put("sourceid", sourceid);
                service.put("_id", isil + "/" + sb.toString());
                multiMap.put((Object)isil, service);
            }
        }
    }

    protected List<Map<String, Object>> extractServices(MarcRecord marcRecord) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        marcRecord.getFields("088").forEach(marcField -> {
            String sigel = marcField.getFirstSubfieldValue("a");
            if (sigel != null) {
                String isil = this.interlibraryConfiguration.normalizeLibraryIdentifier(sigel);
                if (isil != null) {
                    Library library = (Library)this.interlibraryConfiguration.getLibraries().get(isil);
                    if (library != null) {
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        map.put("isil", library.getISIL());
                        map.put("name", library.getName());
                        map.put("domain", library.getDomainName());
                        map.put("organization", library.getDomain().getOrganization());
                        this.putIf(map, "collection", marcField.getFirstSubfieldValue("b"));
                        this.putIf(map, "callnumber", marcField.getFirstSubfieldValue("c"));
                        this.putIf(map, "description", marcField.getFirstSubfieldValue("d"));
                        String status = marcField.getFirstSubfieldValue("e");
                        if (status != null) {
                            this.putIf(map, "status", status);
                            this.putIf(map, "code", (List)this.getStatusCodes().get(status));
                        } else {
                            this.putIf(map, "code", Arrays.asList("copy", "loan"));
                        }
                        list.add(map);
                    } else {
                        logger.log(Level.WARNING, () -> "no library configured for ISIL: " + isil);
                    }
                } else {
                    logger.log(Level.WARNING, () -> "undefined identifier: " + sigel);
                }
            }
        });
        return list;
    }

    protected List<Map<String, Object>> extractLinks(MarcRecord marcRecord) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        marcRecord.getFields("655").forEach(marcField -> {
            LinkedHashMap map = new LinkedHashMap();
            this.putIf(map, "uri", marcField.getFirstSubfieldValue("u"));
            this.putIf(map, "publicnote", marcField.getFirstSubfieldValue("x"));
            this.putIf(map, "nonpublicnote", marcField.getFirstSubfieldValue("y"));
            list.add(map);
        });
        return list;
    }

    protected List<String> extractFormatCodes(MarcRecord marcRecord) {
        ArrayList<String> list = new ArrayList<String>();
        marcRecord.getFields("051").forEach(marcField -> {
            String code = marcField.getFirstSubfieldValue(" ");
            for (Map.Entry<String, Object> entry : this.getMonographCodes().entrySet()) {
                int i = Integer.parseInt(entry.getKey());
                Map map = (Map)entry.getValue();
                String s = (String)map.get(code.substring(i, i + 1));
                if (s == null) continue;
                list.add(s);
            }
        });
        marcRecord.getFields("052").forEach(marcField -> {
            String code = marcField.getFirstSubfieldValue(" ");
            for (Map.Entry<String, Object> entry : this.getSerialCodes().entrySet()) {
                int i = Integer.parseInt(entry.getKey());
                Map map = (Map)entry.getValue();
                String s = (String)map.get(code.substring(i, i + 1));
                if (s == null) continue;
                list.add(s);
            }
        });
        return list;
    }

    private Map<String, Object> makeLocation(MarcField.Subfield subfield, Map<String, Object> location, StringBuilder sb, List<Map<String, Object>> list) {
        Map result = location;
        switch (subfield.getId()) {
            case "a": {
                break;
            }
            case "b": {
                result = this.nextElement(list, location, "collection", subfield.getValue());
                if (sb.length() > 0) {
                    sb.append("/");
                }
                sb.append(subfield.getValue());
                break;
            }
            case "c": {
                result = this.nextElement(list, location, "callnumber", subfield.getValue());
                if (sb.length() > 0) {
                    sb.append("/");
                }
                sb.append(subfield.getValue());
                break;
            }
            case "d": {
                result = this.nextElement(list, location, "description", subfield.getValue());
                break;
            }
            case "e": {
                result = this.nextElement(list, location, "publicnote", subfield.getValue());
                break;
            }
            default: {
                logger.log(Level.WARNING, () -> "extra information in holdings field: " + subfield);
            }
        }
        return result;
    }

    protected boolean isOnline(MarcRecord marcRecord) {
        return marcRecord.getFields("062").stream().anyMatch(marcField -> this.isStartOf("cr", marcField.getFirstSubfieldValue("b"))) || marcRecord.getFields("652").stream().anyMatch(marcField -> this.isStartOf("Online-Ressource", marcField.getFirstSubfieldValue("a")));
    }

    public String getName() {
        return "HBZ";
    }
}

