/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.z.hbz;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.search.pqf.PQFRequest;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.z.AbstractZPQFService;
import org.xbib.interlibrary.z.ZClientHelper;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcRecord;

public class PQFService
extends AbstractZPQFService {
    private static final Logger logger = Logger.getLogger(PQFService.class.getName());
    private final Map<String, Object> country;
    private final Map<String, Object> language;
    private static final List<String> creatorFields = Arrays.asList("100", "104", "108", "112", "116", "120", "124", "128", "132", "136", "140", "144", "148", "152", "156", "160", "164", "168", "172", "176", "180", "184", "188", "192", "196", "200", "204", "208", "212", "216", "220", "224", "228", "232", "236", "240", "244", "248", "252", "256", "260", "264", "268", "272", "276", "280", "284", "288", "292", "296");
    private static final List<String> titleFields = Arrays.asList("310", "331", "335", "359", "360");

    protected PQFService(Settings settings, ServiceArguments arguments, ZClientHelper client) {
        super(settings, arguments, client);
        try {
            this.country = PQFService.getMap((String)"/org/xbib/interlibrary/z/hbz/country.json");
            this.language = PQFService.getMap((String)"/org/xbib/interlibrary/z/hbz/language.json");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected Object processSearchResult(InputStream inputStream) {
        String format = this.client.getSettings().get("connection.format");
        String type = this.client.getSettings().get("connection.type");
        Charset charset = Charset.forName(this.client.getSettings().get("connection.encoding"));
        Marc.Builder marcBuilder = Marc.builder().setFormat(format).setType(type).setInputStream(inputStream).setCharset(charset);
        ArrayList list = new ArrayList();
        for (MarcRecord marcRecord : marcBuilder.iterable()) {
            logger.log(Level.FINE, () -> "result: record = " + marcRecord);
            LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
            this.putIf(map, "id", this.extractIdentifier(marcRecord));
            this.putIf(map, "creator", this.extractCreators(marcRecord));
            this.putIf(map, "title", this.extractTitle(marcRecord));
            this.putIf(map, "country", this.extractCountry(marcRecord));
            this.putIf(map, "language", this.extractLanguage(marcRecord));
            this.putIf(map, "publishedAt", this.extractPublishedAt(marcRecord));
            this.putIf(map, "publishedBy", this.extractPublishedBy(marcRecord));
            this.putIf(map, "publishedOn", this.extractPublishedOn(marcRecord));
            this.putIf(map, "issn", this.extractISSN(marcRecord));
            this.putIf(map, "isbn", this.extractISBN(marcRecord));
            this.putIf(map, "zdb", this.extractZDB(marcRecord));
            this.putIf(map, "firstdate", this.extractFirstDate(marcRecord));
            this.putIf(map, "format", this.extractFormatCodes(marcRecord));
            map.put("service", this.extractServices(marcRecord));
            map.put("links", this.extractLinks(marcRecord));
            list.add(map);
        }
        return list.size() == 1 ? list.get(0) : list;
    }

    protected String getIdentifierField() {
        return "001";
    }

    protected List<String> getCreatorFields() {
        return creatorFields;
    }

    protected List<String> getTitleFields() {
        return titleFields;
    }

    protected String getCountryField() {
        return "036";
    }

    protected Map<String, Object> getCountryMap() {
        return this.country;
    }

    protected String getLanguageField() {
        return "037";
    }

    protected Map<String, Object> getLanguageMap() {
        return this.language;
    }

    public String getName() {
        return "HBZ";
    }

    public PQFRequest validate(PQFRequest request) {
        return request;
    }
}

