/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.z.hbz;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.resolve.ResolveRequest;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.common.DefaultBibliographicDescription;
import org.xbib.interlibrary.z.AbstractZResolveService;
import org.xbib.interlibrary.z.ZClientHelper;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;

public class ResolveService
extends AbstractZResolveService {
    private static final Logger logger = Logger.getLogger(ResolveService.class.getName());

    public ResolveService(Settings settings, ServiceArguments arguments, ZClientHelper client) {
        super(settings, arguments, client);
    }

    protected void resolve(InputStream inputStream, DefaultBibliographicDescription.Builder descriptionBuilder, Map<String, Object> document) {
        String format = this.client.getSettings().get("connection.format");
        String type = this.client.getSettings().get("connection.type");
        Charset charset = Charset.forName(this.client.getSettings().get("connection.encoding"));
        Marc.Builder builder = Marc.builder().setFormat(format).setType(type).setInputStream(inputStream).setCharset(charset);
        for (MarcRecord marcRecord : builder.iterable()) {
            logger.log(Level.FINE, () -> "resolve: record = " + marcRecord);
            for (MarcField marcField : marcRecord.getFields("001")) {
                String hbzId = marcField.getValue();
                if (hbzId == null) continue;
                descriptionBuilder.setSource("HBZ");
                descriptionBuilder.setSourceId(hbzId.trim());
            }
            for (MarcField marcField : marcRecord.getFields("025")) {
                String zdbID = marcField.getFirstSubfieldValue("z");
                if (zdbID == null) continue;
                descriptionBuilder.setSource("ZDB");
                descriptionBuilder.setSourceId(zdbID);
            }
            document.clear();
            document.putAll((Map<String, Object>)marcRecord);
        }
    }

    public String getName() {
        return "HBZ";
    }

    public ResolveRequest validate(ResolveRequest request) {
        return request;
    }
}

