package org.xbib.interlibrary.z.swb;

import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.search.cql.CQLRequest;
import org.xbib.interlibrary.api.service.ServiceArguments;
import org.xbib.interlibrary.z.AbstractZCQLService;
import org.xbib.interlibrary.z.ZClientHelper;
import org.xbib.marc.Marc;
import org.xbib.marc.MarcField;
import org.xbib.marc.MarcRecord;
import org.xbib.marc.label.RecordLabel;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 */
public class CQLService extends AbstractZCQLService {

    private static final Logger logger = Logger.getLogger(CQLService.class.getName());

    protected CQLService(Settings settings,
                         ServiceArguments arguments,
                         ZClientHelper client) {
        super(settings, arguments, client);
    }

    @Override
    protected Map<String, Object> processSearchResult(InputStream inputStream) {
        //String format = client.getSettings().get("connection.format");
        //String type = client.getSettings().get("connection.type");
        Charset charset = Charset.forName(client.getSettings().get("connection.encoding"));
        Map<String, Object> map = new LinkedHashMap<>();
        Marc.Builder builder = Marc.builder()
                .setInputStream(inputStream)
                .setCharset(charset);
        for (MarcRecord marcRecord : builder.iterable()) {
            logger.log(Level.FINE, () -> "result: record = " + marcRecord);
            extractLok(marcRecord);
            //List<MarcRecord> locs = extractLok(marcRecord);
            //logger.log(Level.FINE, "locs=" + locs.toString());
        }
        return map;
    }

    @Override
    protected String getIdentifierField() {
        return "001";
    }

    @Override
    protected List<String> getCreatorFields() {
        return Collections.singletonList("100");
    }

    @Override
    protected List<String> getTitleFields() {
        return Collections.singletonList("245");
    }

    @Override
    protected String getCountryField() {
        return "044";
    }

    @Override
    protected Map<String, Object> getCountryMap() {
        return new DefaultHashMap();
    }

    @Override
    protected String getLanguageField() {
        return "041";
    }

    @Override
    protected Map<String, Object> getLanguageMap() {
        return new DefaultHashMap();
    }

    @Override
    public String getName() {
        return "SWB";
    }

    @Override
    public CQLRequest validate(CQLRequest request) {
        return request;
    }

    private List<MarcRecord> extractLok(MarcRecord marcRecord) {
        List<MarcRecord> marcRecords = new ArrayList<>();
        Marc.Builder marcBuilder = null;
        for (MarcField marcField : marcRecord.getFields("LOK")) {
            String value = marcField.getFirstSubfieldValue("0");
            if (value.startsWith("000")) {
                if (marcBuilder != null) {
                    marcRecords.add(marcBuilder.buildRecord());
                }
                marcBuilder = Marc.builder();
                RecordLabel recordLabel = RecordLabel.builder()
                        .from(value.substring(3).toCharArray())
                        .setSubfieldIdentifierLength(2)
                        .build();
                marcBuilder.recordLabel(recordLabel);
            } else {
                if (marcBuilder != null) {
                    MarcField.Builder builder = MarcField.builder();
                    builder.tag(value.substring(0, 3))
                            .indicator(value.substring(3, 5));
                    if (!value.substring(5).isEmpty()) {
                        builder.value(marcBuilder.getRecordLabel(), value.substring(5));
                    }
                    if (!marcField.getSubfields().isEmpty()) {
                        for (MarcField.Subfield subfield : marcField.getSubfields()) {
                            if (!subfield.getId().equals("0")) {
                                builder.subfield(subfield);
                            }
                        }
                    }
                    MarcField mf = builder.build();
                    marcBuilder.addField(mf);
                }
            }
        }
        if (marcBuilder != null) {
            marcRecords.add(marcBuilder.buildRecord());
        }
        return marcRecords;
    }
}
